		/*////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//
		//				CLEAN LIGHT SHADERS v1.3 by L00 
		//				
		//				PRESET: RED DEAD REDEMPTION II : CLEAN LIGHT
		//				
		//				DO NOT REDISTRIBUTE AND DO NOT SELL THIS FILE.
		//				IF YOU BOUGHT THIS FILE FROM A PAYWALLED PRESET : ASK FOR A REFUND!
		//
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//
		//				NO PERMISSION IS GRANTED TO USE THIS FILE, THE PRESETS 
		//				AND THE SETTINGS WITH ANOTHER PRESET THAN THE ONE ABOVE.
		//
		//				CREDITS: this file is a collection of personal or modified codes
		//				from many different sources customised and put together 
		//				to work in synergy with shared variables to offer a specific experience.
		//
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//				QUICK CTRL+F ACCESS :
		//
		//				UI_ENVIRONMENT 		- UI_SKY - UI_FOG - UI_GI - UI_LIGHTING
		//				UI_LENS 			- UI_DOF - UI_LENSQUALITY - UI_SHAKING - UI_LENSHAZE - UI_LENSBLOOM 
		//									- UI_LENSSHADOW - UI_LENSDISTORTION
		//				UI_CAMERA 			- UI_TONEMAP - UI_AGX - UI_WHITEBALANCE
		//				UI_POSTPROCESSING 	- UI_LUT - UI_OUTPUT - UI_DEBANDING
		//				UI_TOOLS
		//				
		// 				SETTINGS 			- S_KEYS - S_UNIFORMS - S_STATICS - S_DEFINITIONS
		// 				TEXTURES_SAMPLERS	- T_GI - T_LENS_HAZE - T_BLOOM - T_GAUSSIAN - T_TONEMAPPING - T_DOF - T_LUTS
		//				FUNCTIONS 			- F_COLOR_METHODS - F_MASKS - F_MATHS - F_CONVERSIONS - F_MATRIX - F_NORMALS
		// 									- F_DOF - F_LUT - F_TONEMAP - F_DITHER
		//				
		//				PS_ENVIRONMENTS 	- PS_NORMALS - PS_AMBIANT_GI - PS_LIGHTING
		//				PS_LENS 			- PS_DOF - PS_LENSHAZE - PS_BLOOM - PS_RATIO - PS_LENS_SHAKE - PS_LENS_DISTORTION 
		//									- PS_GAUSSIAN_BLUR - PS_LENS_SHARP
		//				PS_CAMERA 			- PS_TONEMAP - PS_WHITE_BALANCE
		//				PS_POSTPROCESSING 	- PS_LUT - PS_LENS_SHADOW - PS_DEBAND - PS_PIXELSHARP - PS_SOFTNESS - PS_OUTPUT
		//				
		//				TECHNIQUES
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////*/


#include "ReShadeUI.fxh"
#include "ReShade.fxh"

namespace L00_CLEAN_LIGHT
{

	uniform int UIVersion <ui_type = "radio";ui_label = " ";ui_text ="v1.0 by L00\nPress HOME to toggle Depth of Field (Performance Boost)\nPress INSERT to toggle Night Settings / Dark mode \n(active if a little icon appears in the bottom left corner of the screen)";
		ui_category = ">> RED DEAD REDEMPTION II :: CLEAN LIGHT <<";ui_category_closed = false;>;
	

		/*//////////////////////////////////////////////////////////////////////////////////////////////////// 
		//										  UI_ENVIRONMENT
		////////////////////////////////////////////////////////////////////////////////////////////////////*/											
uniform bool bENABLE_ENV <ui_label = "ENABLE ENVIRONMENT";ui_category = ":: ENVIRONMENT ::";ui_category_closed = true;> = false;

// UI_SKY //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////  

	uniform bool bSkyControl <ui_label = "SKY";ui_category = ":: ENVIRONMENT ::";> = false;

	uniform float skyDistance <__UNIFORM_SLIDER_FLOAT1
		ui_label = "Sky: Distance";ui_category = ":: ENVIRONMENT ::";ui_min = 1.0;ui_max = 1000.0;ui_step = 1.0;> = 200.0;
		
	uniform float skyExposure <__UNIFORM_SLIDER_FLOAT1
		ui_label = "Sky: Brightness";ui_category = ":: ENVIRONMENT ::";ui_min = -4.0;ui_max = 4.0;ui_step = 0.01;> = 0.0;

	uniform int skyColorThreshold <__UNIFORM_SLIDER_FLOAT1
		ui_label = "Sky: Brightness Threshold";ui_category = ":: ENVIRONMENT ::";ui_min = 1;ui_max = 255;> = 64.0;

	uniform bool bskyColorLuma <ui_label = "Sky: Lum709";ui_category = ":: ENVIRONMENT ::";> = false;

	uniform bool bskySoftExp <ui_label = "Sky: Soft Push";ui_category = ":: ENVIRONMENT ::";> = false;

	uniform float skyBlueShift <__UNIFORM_SLIDER_FLOAT1
		ui_label = "Sky: Blue Shift";ui_category = ":: ENVIRONMENT ::";ui_min = -1.0;ui_max = 1.0;ui_step = 0.01;> = 0.0;

	uniform int iNBTS <__UNIFORM_SLIDER_FLOAT1
		ui_label = "Sky: Land % Ratio";ui_category = ":: ENVIRONMENT ::";ui_min = 0;ui_max = 100;ui_step = 5;> = 0.0;

	uniform int iShowSkyMask <
		ui_category = ":: ENVIRONMENT ::";ui_type = "combo";ui_label = "Sky: Show Masks";ui_items = "None\0Sky\0Land\0";> = false;

		uniform int _spacer1 <ui_type = "radio";ui_label = "  ";ui_text =" ";ui_category = ":: ENVIRONMENT ::";>;
		
// UI_FOG ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////  

	uniform bool bFogControl <ui_label = "FOG";ui_category = ":: ENVIRONMENT ::";> = false;

	uniform float fogCompression <__UNIFORM_SLIDER_FLOAT1
		ui_label = "Fog: Compression";ui_category = ":: ENVIRONMENT ::";ui_min = 0.5;ui_max = 2.0;ui_step = 0.01;> = 1.0;

	uniform float2 fogZone < __UNIFORM_SLIDER_FLOAT1
		ui_min = 5.0; ui_max = 1000.0;ui_step = 5.0; ui_label = "Fog: Distance [Fade In : Fade Out]"; ui_category = ":: ENVIRONMENT ::";> = 1.0;

	uniform float fFogCurve <__UNIFORM_SLIDER_FLOAT1
		ui_label = "Fog: Depth Curve";ui_category = ":: ENVIRONMENT ::";ui_min = 0.01;ui_max = 1.0;ui_step = 0.1;> = 0.5;

	uniform float fogBlueShift <__UNIFORM_SLIDER_FLOAT1
		ui_label = "Fog: Blue Shift";ui_category = ":: ENVIRONMENT ::";ui_min = -1.0;ui_max = 1.0;ui_step = 0.1;> = 0.0;
		
	uniform bool bFogPush <ui_label = "FOG PUSH";ui_category = ":: ENVIRONMENT ::";> = false;
	
	uniform float2 fogPushDepth <__UNIFORM_SLIDER_FLOAT1
		ui_label = "FogPush: Perceptual Depth | Distance";ui_category = ":: ENVIRONMENT ::";ui_min = 0.0;ui_max = 5.0;ui_step = 0.1;> = float2(0.0,1.0);
	
	uniform bool bFogPushWithSky <ui_label = "FogPush: Sky too ?";ui_category = ":: ENVIRONMENT ::";> = false;
	
	uniform int iShowFogMask <
		ui_category = ":: ENVIRONMENT ::";ui_type = "combo";ui_label = "Fog: Show Masks";ui_items = "None\0Fog\0PushFog\0";> = false;
		
		uniform int _spacer2 <ui_type = "radio";ui_label = "   ";ui_text ="  ";ui_category = ":: ENVIRONMENT ::";>;

// UI_GI ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////  

	uniform bool bGiControl <ui_label = "SCREEN SPACE GLOBAL ILLUMINATION";ui_category = ":: ENVIRONMENT ::";> = false;

	uniform float fAmbIntensity < __UNIFORM_SLIDER_FLOAT1
		ui_min = 0.0; ui_max = 250.0; ui_step = 1.0; ui_label = "Gi: Radiance"; ui_category = ":: ENVIRONMENT ::";> = 10.0;

	uniform float fRadPrecision < __UNIFORM_SLIDER_FLOAT1
		ui_min = 0.0; ui_max = 1.0;ui_step = 0.05; ui_label = "Gi: Radiance Sculpt"; ui_category = ":: ENVIRONMENT ::";> = 0.5;

	uniform float fIBLIntensity < __UNIFORM_SLIDER_FLOAT1
		ui_min = 0.0; ui_max = 100.0; ui_step = 1.0; ui_label = "Gi: Image Base Lighting"; ui_category = ":: ENVIRONMENT ::";> = 10.0;

	uniform float fGiCompression < __UNIFORM_SLIDER_FLOAT1
		ui_min = 1.0; ui_max = 2.0;ui_step = 0.1; ui_label = "Gi: Compression"; ui_category = ":: ENVIRONMENT ::";> = 1.00;

	uniform float fGiSaturation < __UNIFORM_SLIDER_FLOAT1
		ui_min = 0.0; ui_max = 2.0;ui_step = 0.1; ui_label = "Gi: Saturation"; ui_category = ":: ENVIRONMENT ::";> = 1.00;

	uniform int iGiBlendMethod <
		ui_category = ":: ENVIRONMENT ::";ui_type = "combo";ui_label = "Gi:Blending";ui_items = "Default\0SoftLight\0Overlay\0Lighten\0Darken\0";> = false;

	uniform float2 fGiZone <__UNIFORM_SLIDER_FLOAT1
		ui_label = "Gi: [Blend Power : Blend Distance]";ui_category = ":: ENVIRONMENT ::";ui_min = 0.01;ui_max = 100.0;ui_step = 0.01;> = 1.0;

	uniform float fGiPreserveHL < __UNIFORM_SLIDER_FLOAT1
		ui_min = 0.0; ui_max = 1.0;ui_step = 0.1; ui_label = "Gi: Highlight Power"; ui_category = ":: ENVIRONMENT ::";> = 0.0;
		
	uniform float fGiEdgeMasking < __UNIFORM_SLIDER_FLOAT1
		ui_min = 0.0; ui_max = 5.0;ui_step = 0.1; ui_label = "Gi: Edges Sculpt"; ui_category = ":: ENVIRONMENT ::";> = 0.0;

	uniform int iShowGiMask <
		ui_category = ":: ENVIRONMENT ::";ui_type = "combo";ui_label = "GI: Show Masks";ui_items = "None\0GI\0Geometry\0Edges\0";> = false;

		uniform int _spacer3 <ui_type = "radio";ui_label = "    ";ui_text ="   ";ui_category = ":: ENVIRONMENT ::";>;

// UI_LIGHTING /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////  

	uniform bool bUseLighting <ui_label = "LIGHTING";ui_category = ":: ENVIRONMENT ::";> = false;
	
	uniform float fGammaDepth < __UNIFORM_SLIDER_FLOAT1
		ui_label = "Depth Enhancement: Gamma"; ui_category = ":: ENVIRONMENT ::";ui_min = 0.1; ui_max = 2.0; ui_step = 0.01;> = 1.0;
	
	uniform bool bReverseGammaDepth <ui_label = "Depth Gamma Enhancement: Rev. Depth";ui_category = ":: ENVIRONMENT ::";> = false;
	
	uniform float fBlackPointDepth < __UNIFORM_SLIDER_FLOAT1
		ui_label = "Depth Enhancement: Black"; ui_category = ":: ENVIRONMENT ::";ui_min = -127.0; ui_max = 0.0f; ui_step = 1;> = 0.0;
	
	uniform float fCloseLightDepth < __UNIFORM_SLIDER_FLOAT1
		ui_label = "Lighting Area"; ui_category = ":: ENVIRONMENT ::";ui_min = 0.0; ui_max = 10.0; ui_step = 0.01;> = 1.0;
	
	uniform float2 fBlueSat < __UNIFORM_SLIDER_FLOAT2
		ui_min = 0.0; ui_max = 2.0;ui_step = 0.1; ui_label = "Lighting: Blue Drop"; ui_category = ":: ENVIRONMENT ::";> = float2(0.0,0.0);

	uniform float fLightingGamma < __UNIFORM_SLIDER_FLOAT1
		ui_min = 0.5; ui_max = 5.0;ui_step = 0.01; ui_label = "Lighting: Compression"; ui_category = ":: ENVIRONMENT ::";> = 1.0;

	uniform bool bUseHLight <ui_label = "LIGHT";ui_category = ":: ENVIRONMENT ::";> = false;
	uniform float fHLWeight < __UNIFORM_SLIDER_FLOAT1
		ui_min = 0.0; ui_max = 20.0;ui_step = 0.1; ui_label = ">> Light: Threshold"; ui_category = ":: ENVIRONMENT ::";> = 4.0;
	
	uniform float fHLExposure < __UNIFORM_SLIDER_FLOAT1
		ui_min = -10.0; ui_max = 10.0;ui_step = 0.1; ui_label = "Light: Exposure"; ui_category = ":: ENVIRONMENT ::";> = 0.0;
	
	uniform float fHLSaturation < __UNIFORM_SLIDER_FLOAT1
		ui_min = -1.0; ui_max = 1.0;ui_step = 0.1; ui_label = "Light: Saturation"; ui_category = ":: ENVIRONMENT ::";> = 0.0;
	
	uniform float fHLContrast < __UNIFORM_SLIDER_FLOAT1
		ui_min = -2.0; ui_max = 2.0;ui_step = 0.1; ui_label = "Light: Contrast"; ui_category = ":: ENVIRONMENT ::";> = 0.0;
	
	uniform float fHLTint < __UNIFORM_SLIDER_FLOAT1
		ui_min = -10.0; ui_max = 10.0;ui_step = 0.1; ui_label = "Light: Temperature"; ui_category = ":: ENVIRONMENT ::";> = 0.0;
	
	uniform bool bUseAmbiant <ui_label = "AMBIANT";ui_category = ":: ENVIRONMENT ::";> = false;
	uniform float fABrightness < __UNIFORM_SLIDER_FLOAT1
		ui_min = -10.0; ui_max = 10.0;ui_step = 0.1; ui_label = "Ambiant: Luminosity"; ui_category = ":: ENVIRONMENT ::";> = 0.0;
	
	uniform float fASaturation < __UNIFORM_SLIDER_FLOAT1
		ui_min = -1.0; ui_max = 1.0;ui_step = 0.1; ui_label = "Ambiant: Saturation"; ui_category = ":: ENVIRONMENT ::";> = 0.0;
	
	uniform float fAContrast < __UNIFORM_SLIDER_FLOAT1
		ui_min = -2.0; ui_max = 2.0;ui_step = 0.1; ui_label = "Ambiant: Contrast"; ui_category = ":: ENVIRONMENT ::";> = 0.0;

	uniform float fATint < __UNIFORM_SLIDER_FLOAT1
		ui_min = -10.0; ui_max = 10.0;ui_step = 0.1; ui_label = "Ambiant: Temperature"; ui_category = ":: ENVIRONMENT ::";> = 0.0;

	uniform bool bUseShadow <ui_label = "SHADOWS";ui_category = ":: ENVIRONMENT ::";> = false;
	uniform float fShadWeight < __UNIFORM_SLIDER_FLOAT1
		ui_min = 0.0; ui_max = 20.0;ui_step = 0.1; ui_label = ">> Shadow Threshold"; ui_category = ":: ENVIRONMENT ::";> = 4.0;

	uniform float fSBrightness < __UNIFORM_SLIDER_FLOAT1
		ui_min = -10.0; ui_max = 10.0;ui_step = 0.1; ui_label = "Shadow: Luminosity"; ui_category = ":: ENVIRONMENT ::";> = 0.0;
	
	uniform float fSVibrance < __UNIFORM_SLIDER_FLOAT1
		ui_min = -1.0; ui_max = 1.0;ui_step = 0.1; ui_label = "Shadow: Saturation"; ui_category = ":: ENVIRONMENT ::";> = 0.0;
	
	uniform float fSContrast < __UNIFORM_SLIDER_FLOAT1
		ui_min = -2.0; ui_max = 2.0;ui_step = 0.1; ui_label = "Shadow: Contrast"; ui_category = ":: ENVIRONMENT ::";> = 0.0;
	
	uniform float fSTint < __UNIFORM_SLIDER_FLOAT1
		ui_min = -10.0; ui_max = 10.0;ui_step = 0.1; ui_label = "Shadow: Temperature"; ui_category = ":: ENVIRONMENT ::";> = 0.0;
	
	uniform int iShowLighting <
		ui_category = ":: ENVIRONMENT ::";ui_type = "combo";ui_label = "Lighting: Show Masks";ui_items = "None\0Area\0Shadow\0Ambiant\0Light\0";> = false;
		

		/*//////////////////////////////////////////////////////////////////////////////////////////////////// 
		//												UI_LENS
		////////////////////////////////////////////////////////////////////////////////////////////////////*/
		
uniform bool bENABLE_LENS <ui_label = "ENABLE LENS";ui_category = ":: LENS ::";ui_category_closed = true;> = false;

// UI_DOF ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 
#define DOF_FOCUSPOINT 		float2(0.50,0.35)
#define DOF_RENDERRESMULT 	0.5f
#define DOF_NEARBLURCURVE 	lerp(0.5, 	2.0, 	fDOFAperture*0.1)
#define DOF_FARBLURCURVE 	lerp(0.25, 	1.0, 	fDOFAperture*0.1)
#define DOF_BLURRADIUS 		lerp(5.0, 	2.5,	fDOFAperture*0.1)*fDOFBlur
#define fMatsoDOFBokehCurve lerp(8.0*fDOFBokeh, 	4.0*fDOFBokeh, 	fDOFAperture*0.1)
#define DOF_INFINITEFOCUS 	1.0 //lerp(1.0,	0.25, 	fDOFAperture*0.1)
#define fMatsoDOFChromaPow 	lerp(4.0,	2.0,	fDOFAperture*0.1)*fDOFCA
#define fMatsoDOFBokehAngle 0
#define fBokehIntensity 	0.95
#define fBokehLuminance		0.956
#define fBokehMin 			0.001
#define fBokehMax 			1.925
#define fBokehMaxLevel 		45.0
#define fBokehMaxWeight 	25.0
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////  

	uniform bool bUseDOF <ui_label = "DEPTH OF FIELD"; ui_category = ":: LENS ::";> = false;

	uniform float fDOFAperture < __UNIFORM_SLIDER_FLOAT1
		ui_min = 1.0; ui_max = 12.0;ui_label = "DOF: Aperture";ui_category = ":: LENS ::";ui_step = 0.2;> = 2.4;

	uniform int iDOFfocus <
		ui_category = ":: LENS ::";ui_type = "combo";ui_label = "DOF: Focus";ui_items = "AUTO\0MANUAL: Click on focal point\0";> = false;

	uniform float fDOFBlur < __UNIFORM_SLIDER_FLOAT1
		ui_min = 0.00; ui_max = 10.00; ui_label = "DOF: Blur Size"; ui_category = ":: LENS ::";ui_step = 0.1;> = 1.00;

	uniform float fDOFBokeh < __UNIFORM_SLIDER_FLOAT1
		ui_min = 0.00; ui_max = 5.00; ui_label = "DOF: Bokeh"; ui_category = ":: LENS ::";ui_step = 0.1;> = 1.00;

	uniform float fDOFCA < __UNIFORM_SLIDER_FLOAT1
		ui_min = 0.00; ui_max = 10.00; ui_label = "DOF: Chromatic Aberration"; ui_category = ":: LENS ::";ui_step = 0.1;> = 1.00;

// UI_LENSQUALITY ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	uniform bool bUseLensBlur <ui_label = "LENS QUALITY"; ui_category = ":: LENS ::";> = false;

	uniform float LensBlur_Offset < __UNIFORM_SLIDER_FLOAT1
		ui_min = 0.00; ui_max = 2.00; ui_label = "Lens softness"; ui_category = ":: LENS ::";> = 0.00;

	uniform float fLensSharpness < __UNIFORM_SLIDER_FLOAT1
		ui_min = 0.1; ui_max = 10.0; ui_step = 0.1; ui_label = "Lens Sharpness"; ui_category = ":: LENS ::";> = 0.65;
		
	uniform float2 fLensSharpnessRadius < __UNIFORM_SLIDER_FLOAT1
		ui_min = 0.0; ui_max = 10.0; ui_step = 0.1; ui_label = "Lens Sharpness Radius [Min | Max]"; ui_category = ":: LENS ::";> = 1.0;

	uniform float fSharpDistance < __UNIFORM_SLIDER_FLOAT1
		ui_min = 0.0; ui_max = 100.0;ui_step = 0.01;ui_label = "Distance Max";ui_category = ":: LENS ::";> = 10.0;

	uniform bool show_sharpen <ui_label = "Show me"; ui_category = ":: LENS ::";> = false;
	
	uniform bool bLinkToBloomDirt <ui_label = "Link to Dirt"; ui_category = ":: LENS ::";> = false;

		uniform int _spacer6 <ui_type = "radio";ui_label = "       ";ui_text ="     ";ui_category = ":: LENS ::";>;

// UI_SHAKING //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#define bUseRandom 0
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	
	uniform bool USE_LensShake <ui_category = ":: LENS ::"; ui_label = "LENS MOTION";> = false;

	uniform int iKBD <
		ui_category = ":: LENS ::"; ui_type = "combo"; ui_label = "Keyboard"; ui_items = "QWERTY\0AZERTY\0";> = false;

	uniform float2 fShakeAmplitude < __UNIFORM_SLIDER_FLOAT2
		ui_label = "Lens Motion Amplitude [Vertical | Horizontal]"; ui_category = ":: LENS ::";ui_min = 0.0; ui_max = 10.0; ui_step = 0.001;> = float2(0.1, 1.0);

	uniform float2 fShakeFrequency < __UNIFORM_SLIDER_FLOAT2
		ui_label = "Lens Motion Amount [Vertical | Horizontal]"; ui_category = ":: LENS ::";ui_min = 0.0; ui_max = 100.0; ui_step = 1.0;> = float2(1.0, 2.0);

	uniform float2 fShakeDuration < __UNIFORM_SLIDER_FLOAT2
		ui_label = "Lens Motion [Duration | Frequency]"; ui_category = ":: LENS ::";ui_min = 0.0; ui_max = 100.0; ui_step = 0.01;> = float2(1.0, 1.0);

		uniform int _spacer7 <ui_type = "radio";ui_label = "        ";ui_text ="      ";ui_category = ":: LENS ::";>;

// UI_LENSHAZE //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 
#define alDirtOVInt fLensDirtIntensity*0.25
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	uniform bool USE_LensHaze <ui_category = ":: LENS ::"; ui_label = "LENS HAZE";> = false;

	uniform float fLensHazeIntensity < __UNIFORM_SLIDER_FLOAT1
		ui_min = 0.0; ui_max = 50.0; ui_step = 0.1; ui_label = "Lens haze intensity"; ui_category = ":: LENS ::";> = 10.0;

	uniform float fLensHazeAdaptation < __UNIFORM_SLIDER_FLOAT1
		ui_min = 0.0; ui_max = 10.0; ui_step = 0.1; ui_label = "Lens Haze dispersion"; ui_category = ":: LENS ::";> = 0.70;
		
	uniform float fLensHazeCompression < __UNIFORM_SLIDER_FLOAT1
		ui_min = 0.0; ui_max = 10.0; ui_step = 0.1; ui_label = "Lens Haze compression"; ui_category = ":: LENS ::";> = 1.00;
		
	uniform float fLensHazeLightLevel < __UNIFORM_SLIDER_FLOAT1
		ui_min = 0; ui_max = 10; ui_label = "Lens Haze Shine"; ui_category = ":: LENS ::";> = 2;

	uniform bool bUseLensDirt <ui_label = "LENS DIRT";ui_category = ":: LENS ::";> = false;

	uniform bool bUseVeryLensDirt <ui_label = "Very Dirty";ui_category = ":: LENS ::";> = false;

	uniform float fLensDirtIntensity < __UNIFORM_SLIDER_FLOAT1
		ui_min = 0.0; ui_max = 100.0; ui_step = 0.1; ui_label = "Lens Dirt intensity"; ui_category = ":: LENS ::";> = 1.0;

	uniform float fLensDirtRefractionPower < __UNIFORM_SLIDER_FLOAT1
		ui_min = 0.0; ui_max = 100.0; ui_step = 0.1; ui_label = "Lens Dirt Refraction power"; ui_category = ":: LENS ::";> = 2.0;

		uniform int _spacer8 <ui_type = "radio";ui_label = "         ";ui_text ="       ";ui_category = ":: LENS ::";>;

// UI_LENSBLOOM /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	uniform bool USE_LensBloom <ui_label = "LENS BLOOM"; ui_category = ":: LENS ::";> = false;

	uniform float2 bloomZone < __UNIFORM_SLIDER_FLOAT1
		ui_min = 0.0; ui_max = 1000.0;ui_step = 0.001; ui_label = "Bloom Input: Area [Cut In : Cut Out]"; ui_category = ":: LENS ::";> = 1.0;

	uniform float fBloomContrast < __UNIFORM_SLIDER_FLOAT1
		ui_min = 0.5; ui_max = 2.0;ui_step = 0.1; ui_label = "Bloom Input: Contrast"; ui_category = ":: LENS ::";> = 1.0;

	uniform float fBloomPushHL < __UNIFORM_SLIDER_FLOAT1
		ui_min = 0.0; ui_max = 2.0;ui_step = 0.1; ui_label = "Bloom Input: Highlight"; ui_category = ":: LENS ::";> = 0.0;

	uniform float fBloomThreshold<
		ui_type = "slider"; ui_category = ":: LENS ::"; ui_label = "Bloom: Shape";ui_min = 0.1; ui_max = 0.9;ui_step = 0.1;> = 0.5;

	uniform float fLensBloomRadius<
		ui_type = "slider"; ui_category = ":: LENS ::"; ui_label = "Bloom: Weight";ui_min = 64.0; ui_max = 256.0;ui_step = 1.0;> = 128.0;

	uniform float fLensBloomIntensity<
		ui_type = "slider";ui_category = ":: LENS ::"; ui_label = "Bloom: Intensity";ui_min = 0.0; ui_max = 10.0;ui_step = 0.1;> = 1;

	uniform float fBloomPreserveHL < __UNIFORM_SLIDER_FLOAT1
		ui_min = 0.0; ui_max = 1.0; ui_step = 0.1; ui_label = "Bloom: Preserve Highlights"; ui_category = ":: LENS ::";> = 0.5;

	uniform float fBloomSaturation<
		ui_type = "slider"; ui_category = ":: LENS ::"; ui_label = "Bloom: Saturation";ui_min = .0; ui_max = 2.0;ui_step = 0.1;> = 1;	

	uniform float fBloomDirtIntensity < __UNIFORM_SLIDER_FLOAT1
		ui_min = 0.0; ui_max = 1.0; ui_step = 0.1; ui_label = "Bloom: Dirt"; ui_category = ":: LENS ::";> = 0.0;

	uniform int iBloomBlendMethod <
		ui_category = ":: LENS ::";ui_type = "combo";ui_label = "Bloom: Blending";ui_items = "Default\0Add\0Screen\0Lighten\0SoftLight\0";> = false;

	uniform bool bBloomWdepth <ui_category = ":: LENS ::"; ui_label = " Soft mode";> = false;

	uniform int iShowBloomMask <
		ui_category = ":: LENS ::";ui_type = "combo";ui_label = "Bloom: Show Masks";ui_items = "None\0Bloom Input\0Bloom Output\0";> = false;

		uniform int _spacer9 <ui_type = "radio";ui_label = "          ";ui_text ="        ";ui_category = ":: LENS ::";>;

// UI_LENSSHADOW ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	uniform bool bUseLenShadow <ui_label = "LENS SHADOW";ui_category = ":: LENS ::";> = false;
		
	uniform float fLensShadowShape < __UNIFORM_SLIDER_FLOAT1
		ui_min = 0.15; ui_max = 10.0; ui_label = "Lens Shadow Shape"; ui_category = ":: LENS ::";> = 1.0;

	uniform int iLensShadowDistance < __UNIFORM_SLIDER_INT1
		ui_min = 2; ui_max = 100; ui_label = "Lens Shadow Distance";ui_category = ":: LENS ::";> = 2;
		
	uniform float fLensShadowSoftness < __UNIFORM_SLIDER_FLOAT1
		ui_min = -5.0; ui_max = 5.0; ui_step = 0.1; ui_label = "Lens Shadow softness";ui_category = ":: LENS ::";> = 2.0;

	uniform float fLensShadowResult < __UNIFORM_SLIDER_FLOAT1
		ui_min = -50.0; ui_max = 1.0;ui_step = 0.1; ui_label = "Lens Shadow Intensity";ui_category = ":: LENS ::";> = -0.5;

		uniform int _spacer10 <ui_type = "radio";ui_label = "           ";ui_text ="         ";ui_category = ":: LENS ::";>;

// UI_LENSDISTORTION /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	uniform bool bUseLensDistortion <ui_label = "LENS DISTORTION";ui_category = ":: LENS ::";> = false;

	uniform float fLensProps < __UNIFORM_SLIDER_FLOAT1
		ui_label = "Lens Proportion";ui_category = ":: LENS ::";ui_min = -1.0; ui_max = 1.0;> = 0.0;
		
	uniform bool FitScreen <ui_label = "Auto scaling"; ui_category = ":: LENS ::";> = false;
	
	uniform bool bLensDistPerfectFit <ui_label = "Pixel Perfect";ui_category = ":: LENS ::";> = false;

	uniform float fFisheyeDistortion <
		ui_type = "drag";ui_min = -1.000; ui_max = 1.000;ui_label = "Lens Fisheye Distortion"; ui_category = ":: LENS ::";> = 0.01;

	uniform float fFisheyeDistortionEdges <
		ui_type = "drag";ui_min = -1.000; ui_max = 1.000;ui_label = "Lens Edges Distortion"; ui_category = ":: LENS ::";> = 0.7;

	uniform float fFisheyeCA <
		ui_type = "drag";ui_min = -1.00; ui_max = 1.00;ui_label = "Lens Chromatic Aberration"; ui_category = ":: LENS ::";> = 0.002;



		/*//////////////////////////////////////////////////////////////////////////////////////////////////// 
		//											UI_CAMERA
		////////////////////////////////////////////////////////////////////////////////////////////////////*/
		
	uniform bool bENABLE_CAMERA <ui_label = "ENABLE CAMERA";ui_category = ":: CAMERA ::";ui_category_closed = true;> = false;

// UI_TONEMAP //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#define AdaptFocalPoint 	float2(0.50,0.35)
#define AdaptTime 			0.5
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 

	uniform int iTonemapCam <
		ui_category = ":: CAMERA ::";ui_type = "combo";ui_label = "Camera: Tonemapper";ui_items = "None\0ACES\0Reinhard\0WatchDog\0JohnHable\0HaarmPeterDuiker\0PP2\0";> = false;

	uniform int fCamIntensity <
		ui_category = ":: CAMERA ::";ui_type = "combo";ui_label = "Camera: Intensity";ui_items = "None\0Very-Low\0Low\0Medium\0High\0Very High\0Full\0";> = false;

	uniform float fCtrstIN <
			ui_label = "Input < LOG : Contrast>";ui_category = ":: CAMERA ::";ui_type = "slider";ui_min = -2.5;ui_max = 5.0;ui_step = 0.05;> = 0.0;

	uniform float fGammaIn <
			ui_label = "Camera: Gamma Space";ui_category = ":: CAMERA ::";ui_type = "slider";ui_min = 0.5;ui_max = 10.0;ui_step = 0.1;> = 1.0;

	uniform float FNumber < __UNIFORM_SLIDER_FLOAT1
		ui_min = 1.0; ui_max = 36.0; ui_step = 0.1; ui_label = "EV: F-Min"; ui_category = ":: CAMERA ::";> = 2.8; 

	uniform float Exposure <__UNIFORM_SLIDER_FLOAT1
		ui_label = "EV: Offset";ui_category = ":: CAMERA ::";ui_min = -6.0;ui_max = 6.0;ui_step = 0.2;> = 0.0;

	uniform float fAdaptCurve <
			ui_label = "EV:: Adaptation Curve";ui_category = ":: CAMERA ::";ui_type = "slider";ui_min = 0.1;ui_max = 50.0;ui_step = 0.1;> = 10.0;

	uniform int AdaptMetering <
		ui_category = ":: CAMERA ::";ui_type = "combo";ui_label = "Exposure: Metering";ui_items = "Matrix\0Center-weighted\0Spot\0";> = false;

	uniform float fTPWhite <
			ui_label = "Exposure: White Levels";ui_category = ":: CAMERA ::";ui_type = "slider";ui_min = 0.0;ui_max = 1.0;ui_step = 0.1;> = 0.0;

		uniform int _spacer110 <ui_type = "radio";ui_label = "                  ";ui_text ="                 ";ui_category = ":: CAMERA ::";>;

// UI_AGX ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 

	uniform bool bAGX <
		ui_label = "AGX CONVERSION";ui_category = ":: CAMERA ::";> = true;
		
	uniform float fAGXGamma <
			ui_label = "AGX: Compression";ui_category = ":: CAMERA ::";ui_type = "slider";ui_min = 0.0;ui_max = 5.0;ui_step = 0.01;> = 1.0;

	uniform int iAGXBlend <
		ui_category = ":: CAMERA ::";ui_type = "combo";ui_label = "AGX: Blend";ui_items = "Convert\0Lighten\0Darken\0SoftLight\0Color\0Luma\0";> = false;

	uniform float INPUT_HIGHLIGHT_GAIN <__UNIFORM_SLIDER_FLOAT1
			ui_type = "drag";ui_min = -6.0;ui_max = 6.0;ui_step = 0.1;ui_label = "Highlight: RollOff";ui_category = ":: CAMERA ::";> = 1.0;

	uniform float INPUT_HIGHLIGHT_GAIN_GAMMA <__UNIFORM_SLIDER_FLOAT1
			ui_type = "drag";ui_min = 0.0;ui_max = 6.0;ui_step = 0.1;ui_label = "Highlight: Threshold";ui_category = ":: CAMERA ::";> = 0.7;

	uniform float fAGXHLSat <
			ui_label = "Highlight: Saturation";ui_category = ":: CAMERA ::";ui_type = "slider";ui_min = 0.0;ui_max = 5.0;ui_step = 0.1;> = 0.0;

		uniform int _spacer11 <ui_type = "radio";ui_label = "            ";ui_text ="          ";ui_category = ":: CAMERA ::";>;

// UI_WHITEBALANCE /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#define AdaptTimeColor 		1.0
#define bMidpointAverage 	0
#define whitepoint_method 	0 //0: channel 1: light
#define blackpoint_method 	0 //0: channel 1: light
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 

	uniform bool AutoWhiteBalance < ui_category = ":: CAMERA ::";> = false;

	uniform float fWhitePointCorrectionIntensity <
			ui_type = "slider";ui_label = "White Point Correction Intensity";ui_category = ":: CAMERA ::";ui_min = 0.0f;ui_max = 1.0f;> = 1.0;

	uniform float fAutoBalanceIntensity <
			ui_type = "slider";ui_label = "Automatic Balance Intensity";ui_category = ":: CAMERA ::";ui_min = 0.0f;ui_max = 5.0f;> = 0.5;
			
	uniform bool bMidpointRespectGamma <
		ui_label = "Gamma Preservation";ui_category = ":: CAMERA ::";> = true;

	uniform uint Kelvin <
			ui_label = "Manual White Balance Offset";ui_category = ":: CAMERA ::";ui_type = "slider";ui_min = 1000;ui_max = 40000;ui_step = 10.0;> = 6500;

	uniform bool LumPreservation <
			ui_label = "Luminance Preservation";ui_category = ":: CAMERA ::";> = true;
			
	
		/*//////////////////////////////////////////////////////////////////////////////////////////////////// 
		//											UI_POSTPROCESSING
		////////////////////////////////////////////////////////////////////////////////////////////////////*/
		
	uniform bool bENABLE_CC <ui_label = "ENABLE POST-PROCESSING";ui_category = ":: POST-PROCESSING ::";ui_category_closed = true;> = false;
			
// UI_LUT ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 
#define LUT_BLOCK_SIZE 64
#define LUT_DIMENSIONS int2(LUT_BLOCK_SIZE*LUT_BLOCK_SIZE, LUT_BLOCK_SIZE)
#define LUT_PIXEL_SIZE 1.0/LUT_DIMENSIONS

texture LUTCCTex < source = "L00_CleanLight.png";>{ Width = LUT_DIMENSIONS.x; Height = LUT_DIMENSIONS.y; Format = RGBA8; };
	sampler LUTCCSampler {Texture = LUTCCTex; };
texture LUTCCTex2 < source = "L00_WIP.png";>{ Width = LUT_DIMENSIONS.x; Height = LUT_DIMENSIONS.y; Format = RGBA8; };
	sampler LUTCCSampler2 {Texture = LUTCCTex2; };
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 

	uniform int iLUTSet <
			ui_category = ":: POST-PROCESSING ::"; ui_type = "combo"; ui_label = " Color Profile"; ui_items = "Raw\0CLEANLIGHT\0WIP TO COMPARE\0";> = false;

	uniform float2 LutChromaLuma < __UNIFORM_SLIDER_FLOAT2
		ui_label = " [Color | Values]"; ui_category = ":: POST-PROCESSING ::";ui_min = 0.0; ui_max = 1.0; ui_step = 0.01;> = float2(1.0, 1.0);

	uniform float fPurkinjeFX <
			ui_label = "Purkinje : Intensity";ui_category = ":: POST-PROCESSING ::";ui_type = "slider";ui_min = 0.0;ui_max = 1.0;ui_step = 0.1;> = 0.0;


		uniform int _spacer12 <ui_type = "radio";ui_label = "             ";ui_text ="           ";ui_category = ":: POST-PROCESSING ::";>;

// UI_OUTPUT ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 

	uniform bool bUseOutput <
		ui_label = "OUTPUT";ui_category = ":: POST-PROCESSING ::";> = false;

	uniform int fPSBP <
			ui_label = "Output : Black";ui_category = ":: POST-PROCESSING ::";ui_type = "slider";ui_min = -32;ui_max = 32;> = 0.0;

	uniform float fGamma <
			ui_label = "Output : Gamma";ui_category = ":: POST-PROCESSING ::";ui_type = "slider";ui_min = 0.1;ui_max = 2.0;ui_step = 0.01;> = 1.0;

	uniform int iCtrstMethod <
			ui_category = ":: POST-PROCESSING ::";ui_type = "combo";ui_label = "Output : Contrast Method";ui_items = "Linear-Point\0LOG-Point\0Curved-Point\0";> = false;

	uniform float fCtrstOut <
			ui_label = "Output : Contrast";ui_category = ":: POST-PROCESSING ::";ui_type = "slider";ui_min = -10.0;ui_max = 10.0;ui_step = 0.1;> = 0.0;

	uniform float fCtrstPoint <
			ui_label = "Output : Contrast Point";ui_category = ":: POST-PROCESSING ::";ui_type = "slider";ui_min = 0.01;ui_max = 1.0;ui_step = 0.01;> = 0.5;

	uniform int fPSWP <
			ui_label = "Output : White";ui_category = ":: POST-PROCESSING ::";ui_type = "slider";ui_min = 125;ui_max = 500;ui_step = 5;> = 255.0;

	uniform float fDesaturateShadows <
			ui_label = "Output : LowLight Desaturation";ui_category = ":: POST-PROCESSING ::";ui_type = "slider";ui_min = 0.0;ui_max = 2.0;ui_step = 0.1;> = 0.0;

	uniform float saturation_limit <
			ui_type = "slider";ui_label = "Output : Saturation Limit";ui_category = ":: POST-PROCESSING ::";ui_min = 0.0;ui_max = 1.0; ui_step = 0.01;> = 1.0;


		uniform int _spacer13 <ui_type = "radio";ui_label = "              ";ui_text ="            ";ui_category = ":: POST-PROCESSING ::";>;

// UI_DEBANDING ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#define offset_bias 		0.2
#define fDetectionRadius 	8
#define DebandDistancecMin 	0.750
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 

	uniform float fDebandPower <
		ui_category = ":: POST-PROCESSING ::";ui_label = "Debanding";ui_max = 5.0;ui_min = 0.0;ui_step = 0.1;ui_type = "slider";> = 0.0;

	uniform int iDitherMethod <
			ui_category = ":: POST-PROCESSING ::";ui_type = "combo";ui_label = "Dithering";ui_items = "None\0Tri-Dithering\0Screen-Space TriDithering\0Interleaved-Gradient TriDithering\0";> = false;

	uniform float fSoftness < __UNIFORM_SLIDER_FLOAT1
		ui_min = -1.00; ui_max = 1.00;ui_step = 0.1; ui_label = "Softness"; ui_category = ":: POST-PROCESSING ::";> = 0.0;

	uniform float fPixelSharpIntensity < __UNIFORM_SLIDER_FLOAT1
		ui_min = 0.0; ui_max = 10.0;ui_step = 0.1; ui_label = "Pixel Sharpness";ui_category = ":: POST-PROCESSING ::";> = 0.0;

	uniform float fLBox < __UNIFORM_SLIDER_FLOAT1
		ui_min = 0.0; ui_max = 1.0;ui_step = 0.01; ui_label = "Letterbox";ui_category = ":: POST-PROCESSING ::";> = 0.0;

		/*//////////////////////////////////////////////////////////////////////////////////////////////////// 
		//											UI_TOOLS
		////////////////////////////////////////////////////////////////////////////////////////////////////*/

	uniform bool bShowDepth <
		ui_label = "Depth";ui_category = ":: DEV_TOOLS ::";ui_category_closed = true;> = false;

	uniform float fTEST < __UNIFORM_SLIDER_FLOAT1
		ui_min = 0.0; ui_max = 10.0;ui_step = 0.001; ui_label = "Test: lemme check this";ui_category = ":: DEV_TOOLS ::";> = 0.5;

	uniform float fTEST2 < __UNIFORM_SLIDER_FLOAT1
		ui_min = 0.0; ui_max = 10.0;ui_step = 0.001; ui_label = "Test: lemme check that";ui_category = ":: DEV_TOOLS ::";> = 0.5;

		uniform int _spacer14 <ui_type = "radio";ui_label = "               ";ui_text ="             ";ui_category = ":: DEV_TOOLS ::";>;

	uniform bool bTEST <
		ui_label = "Test: yes or no ?";ui_category = ":: DEV_TOOLS ::";> = false;

	uniform bool bValueCheck <
		ui_label = "B&W Check";ui_category = ":: DEV_TOOLS ::";> = false;

	uniform bool DEVBUILD <
			ui_label = "DevBuild";ui_category = ":: DEV_TOOLS ::";> = false;


		/*////////////////////////////////////////////////////////////////////////////////////////////////////
		//////////////////////////////////////////////////////////////////////////////////////////////////////
		
		//											SETTINGS 
		
		//////////////////////////////////////////////////////////////////////////////////////////////////////
		////////////////////////////////////////////////////////////////////////////////////////////////////*/

// S_KEYS
// NIGHT 
uniform bool kInsert <source="key"; keycode=45; toggle=true;>; //https://keycode.info //
//Shortcut DOF
uniform bool kHome <source="key"; keycode=36; toggle=true;>; //https://keycode.info //
//
uniform bool kDel <source="key"; keycode=46; toggle=true;>; //https://keycode.info //
//
uniform bool kStrafeLeft <source="key"; keycode=81; toggle=false;>; //https://keycode.info //
uniform bool kStrafeLeftUS <source="key"; keycode=65; toggle=false;>; //https://keycode.info //
uniform bool kStrafeRight <source="key"; keycode=68; toggle=false;>; //https://keycode.info //
//
uniform bool kStrafeForward <source="key"; keycode=90; toggle=false;>; //https://keycode.info //
uniform bool kStrafeForwardUS <source="key"; keycode=87; toggle=false;>; //https://keycode.info //
uniform bool kStrafeBack <source="key"; keycode=83; toggle=false;>; //https://keycode.info //

// MOUSE
uniform bool RightMouseDown < source = "mousebutton"; keycode = 1; toggle = false; >; //FOR ME TESTING ONLY
uniform bool LeftMouseDown < source = "mousebutton"; keycode = 0; toggle = true; >; 
uniform float2 MouseCoords < source = "mousepoint"; >;



// S_UNIFORMS
uniform float 	Timer < source = "timer"; >;
uniform float 	FrameTime <source = "frametime";>;
uniform int 	Frame < source = "framecount"; >;
uniform float2 	LH_timer < source = "pingpong"; min = 0.0f; max = 6.28f; step = float2(0.1f, 0.2f); >;
uniform float2 	Gi_timer < source = "pingpong"; min = 0.0f; max = 6.28f; step = float2(0.1f, 0.2f); >;
uniform int 	drandom < source = "random"; min = 0; max = 32767; >;

// S_STATICS
static const int2 	AdaptResolution = 256;
static const int 	AdaptMipLevels = 9;
static const float3 LumaWeights = float3(0.299, 0.587, 0.114);
static const float2 f2Resolution = float2(BUFFER_WIDTH, BUFFER_HEIGHT);
static const float2 f2PixelSize = 1.0 / f2Resolution;
static const float2 pix = float2(BUFFER_RCP_WIDTH, BUFFER_RCP_HEIGHT);
static const float3 Luma709 = float3(0.2126, 0.7152, 0.0722); // RGB 
static const float3 cold       = float3( 0.0f,  0.365f, 1.0f ); //LBB
static const float3 warm       = float3( 0.98f, 0.588f, 0.0f ); //LBA

// S_DEFINITIONS
// General
#ifndef BUFFER_PIXEL_SIZE
	#define BUFFER_PIXEL_SIZE	ReShade::PixelSize
#endif
#ifndef BUFFER_SCREEN_SIZE
	#define BUFFER_SCREEN_SIZE	ReShade::ScreenSize
#endif

#define LHGI_PIXEL_SIZE 	float2(1.0f / (BUFFER_WIDTH / 16.0f), 1.0f / (BUFFER_HEIGHT / 16.0f))
#define AspectRatio 		BUFFER_WIDTH/BUFFER_HEIGHT
#define perfectCenter 		float2(0.5f,0.5f)
#define BlackColor 			float4(0.0,0.0,0.0,1.0)
#define LDepth 				ReShade::GetLinearizedDepth
#define FAR_PLANE 			RESHADE_DEPTH_LINEARIZATION_FAR_PLANE 

// Dither
#define mod(x,y) 			(x-y*floor(x/y))
#define ftimer2 			Timer*0.001
#define remap(v, a, b) 		(((v) - (a)) / ((b) - (a)))
float Linear1(float c)		{return(c<=0.04045)?c/12.92:pow((c+0.055)/1.055,2.4);}
#define STEPS 				256.0

// Normal Smoothing
#define SNThreshold 		2.5
#define SNDepthW 			FAR_PLANE*1*SNThreshold
#define LODD 				0
#define SNWidth 			2.5
#define SNSamples 			3

// Softening blur
#define KERNEL_SIZE 		23
#define KERNEL_RADIUS 		(KERNEL_SIZE / 2)
#define SAMPLES_PER_THREAD 	4
#define GROUP_WIDTH 		32
#define GROUP_HEIGHT 		2
#define ARRAY_DIMENSIONS 	int2(GROUP_WIDTH * SAMPLES_PER_THREAD + (KERNEL_RADIUS * 2), GROUP_HEIGHT)
#define DIVIDE_ROUNDING_UP(numerator, denominator) uint((numerator + denominator - 1) / int(denominator))

// Bloom
#define FILTER_WIDTH 		256
#define PIXELS_PER_THREAD 	256
#define H_GROUPS uint2(DIVIDE_ROUNDING_UP(BUFFER_WIDTH, PIXELS_PER_THREAD), DIVIDE_ROUNDING_UP(BUFFER_HEIGHT, 64))
#define V_GROUPS uint2(DIVIDE_ROUNDING_UP(BUFFER_WIDTH, 64), DIVIDE_ROUNDING_UP(BUFFER_HEIGHT, PIXELS_PER_THREAD))
#define H_GROUP_SIZE 		uint2(1, 64)
#define V_GROUP_SIZE 		uint2(64, 1)
#define PI 					3.1415962

		/*////////////////////////////////////////////////////////////////////////////////////////////////////
		//////////////////////////////////////////////////////////////////////////////////////////////////////
		
		//										TEXTURES_SAMPLERS 
		
		//////////////////////////////////////////////////////////////////////////////////////////////////////
		////////////////////////////////////////////////////////////////////////////////////////////////////*/
	
// T_BUFFER
texture BackBufferTex : COLOR;	
sampler BackBuffer
{
	Texture = ReShade::BackBufferTex;
	AddressU = MIRROR;
	AddressV = MIRROR;
	#if BUFFER_COLOR_BIT_DEPTH != 10
		SRGBTexture = true;
	#endif
};

sampler BackBuffer_Point {Texture = BackBufferTex;SRGBTexture = true;MinFilter = POINT;MagFilter = POINT;MipFilter = POINT;};
sampler BackBuffer_Linear{Texture = BackBufferTex;SRGBTexture = true;};

// T_GI
texture GiInTex  { Width = BUFFER_WIDTH / 16; Height = BUFFER_HEIGHT / 16; Format = RGBA32F; };
	sampler GiInColor { Texture = GiInTex; };
texture GiOutTex { Width = BUFFER_WIDTH / 16; Height = BUFFER_HEIGHT / 16; Format = RGBA32F; };
	sampler GiOutColor { Texture = GiOutTex; };
texture GidetectIntTex { Width = 32; Height = 32; Format = RGBA8; };
	sampler GidetectIntColor { Texture = GidetectIntTex; };
texture GidetectLowTex { Width = 1; Height = 1; Format = RGBA8; };
	sampler GidetectLowColor { Texture = GidetectLowTex; };
texture SSSR_NormTex  { Width = BUFFER_WIDTH; Height = BUFFER_HEIGHT; Format = RGBA16f;MipLevels = 4; };
	sampler sSSSR_NormTex { Texture = SSSR_NormTex; };

// T_LENS_HAZE
texture LHTexIn  { Width = BUFFER_WIDTH / 16; Height = BUFFER_HEIGHT / 16; Format = RGBA32F; };
	sampler LHS_ColorIn { Texture = LHTexIn; };
texture LHTexOut { Width = BUFFER_WIDTH / 16; Height = BUFFER_HEIGHT / 16; Format = RGBA32F; };
	sampler LHS_ColorOut { Texture = LHTexOut; };
texture LHTexHighDetect { Width = 32; Height = 32; Format = RGBA8; };
	sampler LHS_HighColorDetect { Texture = LHTexHighDetect; };
texture LHTexLowDetect { Width = 1; Height = 1; Format = RGBA8; };
	sampler LHS_LowColorDetect { Texture = LHTexLowDetect; };
texture LHdirtTex    < source = "LensBloomDirtM.jpg";    > { Width = 1920; Height = 1080; MipLevels = 1; Format = RGBA8; };
	sampler LHS_Dirt { Texture = LHdirtTex; };
texture LHdirtMTex    < source = "LensBloomDirtM.jpg";    > { Width = 1280; Height = 720; MipLevels = 1; Format = RGBA8; };
	sampler LHS_DirtM { Texture = LHdirtMTex; };
texture LHdirtOVRTex < source = "LensRefractionRed.jpg"; > { Width = 1920; Height = 1080; MipLevels = 1; Format = RGBA8; };
	sampler LHS_DirtOVR { Texture = LHdirtOVRTex; };
texture LHdirtOVBTex < source = "LensRefractionBlue.jpg"; > { Width = 1920; Height = 1080; MipLevels = 1; Format = RGBA8; };
	sampler LHS_DirtOVB { Texture = LHdirtOVBTex; };
texture LHlensDBTex  < source = "LensDirt.jpg";  > { Width = 1920; Height = 1080; MipLevels = 1; Format = RGBA8; };
	sampler LHS_DBLens { Texture = LHlensDBTex; };
texture LHlensDB2Tex < source = "LensDirt.jpg"; > { Width = 1920; Height = 1080; MipLevels = 1; Format = RGBA8; };
	sampler LHS_DB2Lens { Texture = LHlensDB2Tex; };
texture LHlensDOVTex < source = "LensDirt.jpg"; > { Width = 1920; Height = 1080; MipLevels = 1; Format = RGBA8; };
	sampler LHS_DOVLens { Texture = LHlensDOVTex; };
texture LHlensDUVTex < source = "LensDirt.jpg"; > { Width = 1920; Height = 1080; MipLevels = 1; Format = RGBA8; };
	sampler LHS_DUVLens { Texture = LHlensDUVTex; };

// T_BLOOM
texture Blur0{Width = BUFFER_WIDTH; Height = BUFFER_HEIGHT; Format = RGBA16f;};
	sampler sBlur0{Texture = Blur0;};
texture Blur1{Width = BUFFER_WIDTH; Height = BUFFER_HEIGHT; Format = RGBA16f;};
	sampler sBlur1{Texture = Blur1;};
storage wBlur0{Texture = Blur0;};
storage wBlur1{Texture = Blur1;};
	
// T_GAUSSIAN
texture GaussianBlur_TEX < pooled = true; > { Width = BUFFER_WIDTH; Height = BUFFER_HEIGHT; Format = RGBA8; };
	sampler GaussianBlur_Sampler { Texture = GaussianBlur_TEX;};
texture GaussianDirtBlur_TEX < pooled = true; > { Width = BUFFER_WIDTH; Height = BUFFER_HEIGHT; Format = RGBA8; };
	sampler GaussianDirtBlur_Sampler { Texture = GaussianBlur_TEX;};
texture PlaceHolder {Width = BUFFER_WIDTH; Height = BUFFER_HEIGHT; Format = RGB10A2;};
texture Convolution {Width = BUFFER_WIDTH; Height = BUFFER_HEIGHT; Format = RGB10A2;};
storage wPlaceHolder {Texture = PlaceHolder;};
	sampler sPlaceHolder {Texture = PlaceHolder;};
storage wConvolution {Texture = Convolution;};
	sampler sConvolution {Texture = Convolution;};

// T_TONEMAPPING
texture texColor { Width = BUFFER_WIDTH; Height = BUFFER_HEIGHT; MipLevels = 5; };
	sampler samplerColor { Texture = texColor; };
texture texDS_1_Max { Width = 32; Height = 32; Format = RGBA16F; };
	sampler samplerDS_1_Max { Texture = texDS_1_Max;MipFilter = POINT;MinFilter = POINT;MagFilter = POINT;};
texture texDS_1_Min { Width = 32; Height = 32; Format = RGBA16F; };
	sampler samplerDS_1_Min {Texture = texDS_1_Min;MipFilter = POINT;MinFilter = POINT;MagFilter = POINT;};
texture texDS_1_Mid { Width = 32; Height = 32; Format = RGBA16F; };
	sampler samplerDS_1_Mid {Texture = texDS_1_Mid;MipFilter = POINT;MinFilter = POINT;MagFilter = POINT;};
texture texDS_1x1 { Width = 6; Height = 2; Format = RGBA16F; };
	sampler samplerDS_1x1 {Texture   = texDS_1x1;MipFilter = POINT;MinFilter = POINT;MagFilter = POINT;};
texture texPrevious { Width = 6; Height = 2; Format = RGBA16F; };
	sampler samplerPrevious { Texture   = texPrevious;MipFilter = POINT;MinFilter = POINT;MagFilter = POINT;};
texture SmallTex {Width = AdaptResolution.x;Height = AdaptResolution.y;Format = R32F;MipLevels = AdaptMipLevels;};
	sampler Small {Texture = SmallTex;};
texture LastAdaptTex {Format = R32F;};
	sampler LastAdapt {Texture = LastAdaptTex;MinFilter = POINT;MagFilter = POINT;MipFilter = POINT;};

// T_DOF
texture texHDR1 { Width = BUFFER_WIDTH * DOF_RENDERRESMULT; Height = BUFFER_HEIGHT * DOF_RENDERRESMULT; Format = RGBA8; };
	sampler SamplerHDR1 { Texture = texHDR1; };
texture texHDR2 { Width = BUFFER_WIDTH * DOF_RENDERRESMULT; Height = BUFFER_HEIGHT * DOF_RENDERRESMULT; Format = RGBA8; }; 
	sampler SamplerHDR2 { Texture = texHDR2; };
texture texDOFPreviousFocus		{ Width = BUFFER_WIDTH * DOF_RENDERRESMULT; Height = BUFFER_HEIGHT * DOF_RENDERRESMULT;Format = R16F; };
	sampler sDOFPreviousFocus { Texture = texDOFPreviousFocus; };
texture texDOFCurrentFocus		{ Width = BUFFER_WIDTH * DOF_RENDERRESMULT; Height = BUFFER_HEIGHT * DOF_RENDERRESMULT;Format = R16F; };
	sampler sDOFCurrentFocus { Texture = texDOFCurrentFocus; };
	
// T_LUTS
texture LUTBLUETex < source = "L00_BlueDrop.png";>{ Width = LUT_DIMENSIONS.x; Height = LUT_DIMENSIONS.y; Format = RGBA8; };
	sampler LUTBLUESampler {Texture = LUTBLUETex; };
texture CtrstDownLUTTex < source = "L00_LINEARtoLOG.png";>{ Width = LUT_DIMENSIONS.x; Height = LUT_DIMENSIONS.y; Format = RGBA8; };
	sampler CtrstDownLUTSampler {Texture = CtrstDownLUTTex; };
texture AGXLUTTex < source = "L00_AGXtoLINEAR.png"; > { Width = LUT_DIMENSIONS.x; Height = LUT_DIMENSIONS.y; Format = RGBA8; };
    sampler2D AGXLUTSampler {Texture = AGXLUTTex;};
texture LUTNightTex < source = "L00_Purkinje.png"; > { Width = LUT_DIMENSIONS.x; Height = LUT_DIMENSIONS.y; Format = RGBA8; };
    sampler2D LUTNightSampler {Texture = LUTNightTex;};

// T_NIGHT
texture tNightSet <source = "OV_NightSet.png";> {Width = BUFFER_WIDTH;Height = BUFFER_HEIGHT;};
	sampler sNightSet { Texture = tNightSet;MinFilter = LINEAR;MagFilter = LINEAR;AddressU = BORDER;AddressV = BORDER;};
	
		/*////////////////////////////////////////////////////////////////////////////////////////////////////
		//////////////////////////////////////////////////////////////////////////////////////////////////////
		
		//											FUNCTIONS 
		
		//////////////////////////////////////////////////////////////////////////////////////////////////////
		////////////////////////////////////////////////////////////////////////////////////////////////////*/

// F_COLOR_METHODS //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 

float GetLuma(float3 color)
{
	return dot(color, Luma709);
}

float getAvgColor( float3 col )
{
    return dot( col.xyz, float3( 0.333333f, 0.333334f, 0.333333f ));
}

float3 GetValueWeight(float3 colorIn) //x shadow y mid z highlight
{
	float Luma = GetLuma(colorIn);
	float3 weight;
	weight.x = pow( 1.0f - Luma, fShadWeight ); //4.0f
	weight.z = pow( Luma, fHLWeight ); //4.0f
	weight.y = saturate( 1.0f - weight.x - weight.z );
	
	if (iShowLighting == 2) return lerp(0, (colorIn+1*float3(1.0,0.0,0.0)), weight.x); //lerp(normalize(colorIn), float3(1.0,0,0), weight.x);
	if (iShowLighting == 3) return lerp(0, (colorIn+1*float3(0.0,0.0,1.0)), weight.y);
	if (iShowLighting == 4) return lerp(0, (colorIn+1*float3(0.0,1.0,0.0)), weight.z);
		else return weight.xyz;
}

// BLENDING
#define BlendScreenf(base, blend) 		(1.0 - ((1.0 - base) * (1.0 - blend)))
#define BlendAddf(base, blend) 		min(base + blend, 1.0)
#define BlendLightenf(base, blend) 		max(blend, base)
#define BlendDarkenf(base, blend) 		min(blend, base)

float3 SoftLight(float3 a, float3 b)
{
	return ((b < 0.5) ? (2.0 * a * b + a * a * (1.0 - 2.0 * b)) : (sqrt(a) * (2.0 * b - 1.0) + 2.0 * a * (1.0 - b)));
}

float3 Overlay(float3 a, float3 b)
{
	return a < 0.5 ? (2.0 * a * b) : (1.0 - 2.0 * (1.0 - a) * (1.0 - b));
}

float3 Softexposure( float3 res, float x )
{
    x = x < 0.0f ? x * 0.333f : x;
    return saturate( res.xyz * ( x * ( 1.0f - res.xyz ) + 1.0f ));
}

float3 Softcontrast( float3 res, float x )
{
    //softlight
    float3 c = SoftLight( res.xyz, res.xyz );
    x = ( x < 0.0f ) ? x * 0.5f : x;
    return saturate( lerp( res.xyz, c.xyz, x ));
}

float3 SoftBrightness( float3 res, float x )
{
    //screen
    float3 c = 1.0f - ( 1.0f - res.xyz ) * ( 1.0f - res.xyz );
    x = ( x < 0.0f ) ? x * 0.5f : x;
    return saturate( lerp( res.xyz, c.xyz, x ));   
}

float3 vibrance( float3 res, float x )
{
    float4 sat = 0.0f;
    sat.xy = float2( min( min( res.x, res.y ), res.z ), max( max( res.x, res.y ), res.z ));
    sat.z = sat.y - sat.x;
    sat.w = GetLuma( res.xyz );
    return saturate( lerp( sat.w, res.xyz, 1.0f + ( x * ( 1.0f - sat.z ))));
}

float3 sat( float3 res, float x )
{
    return saturate( lerp( GetLuma( res.xyz ), res.xyz, x + 1.0f ));
}


// F_MASKS //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 

float GetLinearDepth(float2 coords)
{
	return LDepth(coords);
}

float linearDepth(float nonLinDepth, float depthNearVar, float depthFarVar)
{
	return (2.0 * depthNearVar) / (depthFarVar + depthNearVar - nonLinDepth * (depthFarVar - depthNearVar));
}

float getSkyMask(float2 uv)
{
	return linearDepth(LDepth(uv), 0.1f, skyDistance);
}


float getLandMask(float2 uv)
{
	return 1-linearDepth(LDepth(uv), 1.0, skyDistance*0.33f);
}

float getFogMask(float2 uv)
{
	float fogDepthStart = linearDepth(LDepth(uv), 2.0f, fogZone.x);
	float fogDepthEnd = linearDepth(LDepth(uv), fFogCurve, fogZone.y);
	
	float fogMask = lerp(fogDepthStart,0.0,fogDepthEnd);
	
	return fogMask;
}

float getFogPushMask(float2 uv)
{
	return bFogPushWithSky ? clamp((LDepth(uv)/fogPushDepth.y)*2,0.1,1.0 ) : clamp((LDepth(uv)/fogPushDepth.y)*2,0.1,1.0)-getSkyMask(uv) ;
}

float GetCloseLightMask(float2 uv)
{
	float fNightMultiplier = kInsert ? 0.5f : 1.0f;
	return 1-clamp((LDepth(uv)/(fCloseLightDepth*fNightMultiplier))*2,0,1 ); 
}

float getBloomMask(float2 uv)
{
	float BloomDepthStart = 1-clamp((1-LDepth(uv)/bloomZone.x)*2,0,1 );
	float BloomDepthEnd = 1-clamp((1-LDepth(uv)/bloomZone.y)*2,0,1 );

	return lerp(BloomDepthStart,0.0,BloomDepthEnd);

}

float getGiMask(float2 uv)
{
	float fGiBlendedMultiplier = (iGiBlendMethod > 0) ? 2.0 : 1.0;

	float giMask =  clamp(1-linearDepth(LDepth(uv), 0.33f, fGiZone),0.01,fGiZone.x*fGiBlendedMultiplier);
	return giMask *= clamp((1-LDepth(uv)/fGiZone.y)*2,0,1 );
}

float getEdges(sampler s, int2 vpos, float2 texcoord) 
{
	float retVal;
	float3 colorC = tex2Dfetch(s, int4(vpos, 0, 0)).rgb;//C

	float2 pix = ReShade::PixelSize;
	float depthC = ReShade::GetLinearizedDepth(texcoord);//C
	float4 depth1[1];

	[unroll]
	for(int i = 0; i < 1; i++)
	{
		depth1[i] = float4(
			ReShade::GetLinearizedDepth(texcoord + (i + 1.0) * float2(   0.0, -pix.y)),//N
			ReShade::GetLinearizedDepth(texcoord + (i + 1.0) * float2( pix.x, -pix.y)),//NE
			ReShade::GetLinearizedDepth(texcoord + (i + 1.0) * float2( pix.x,    0.0)),//E
			ReShade::GetLinearizedDepth(texcoord + (i + 1.0) * float2( pix.x,  pix.y))//SE
		);
	   
	}

	float3 vertCenter = float3(texcoord, depthC);
	float3 vertNorth = float3(texcoord + float2(0.0, -pix.y), depth1[0].x);
	float3 vertEast = float3(texcoord + float2(pix.x, 0.0), depth1[0].z);
	retVal = (1.0 - saturate(normalize(cross(vertCenter - vertNorth, vertCenter - vertEast)) * 0.5 + 0.5)).z;

	return saturate(retVal);
}


// F_MATHS //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 

float ResModifier()
{
	return BUFFER_HEIGHT/1440.0f;
}

float random(float x)
{
    return frac(x / 41.0);
}

float rand21(float2 uv)
{
    float2 noise = frac(sin(dot(uv, float2(12.9898, 78.233) * 2.0)) * 43758.5453);
    return (noise.x + noise.y) * 0.5;
}

float rand11(float x)
{
    return frac(x * 0.024390243);
}

float permute(float x)
{
    return ((34.0 * x + 1.0) * x) % 289.0;
}

float3 powsafe(float3 color, float power)
{
	return pow(abs(color), power) * sign(color);
}

float smootherstep(float edge0, float edge1, float x)
{
   	x = clamp((x - edge0)/(edge1 - edge0), 0.0, 1.0);
   	return x*x*x*(x*(x*6 - 15) + 10);
}


// F_CONVERSIONS //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
float3 cctf_decoding_pow2_2(float3 color){return powsafe(color, 2.2);}
float3 cctf_encoding_pow2_2(float3 color){return powsafe(color, 1/2.2);}
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 

float HueToRGB(float f1, float f2, float hue)
{
	if (hue < 0.0)
		hue += 1.0;
	else if (hue > 1.0)
		hue -= 1.0;
	float res;
	if ((6.0 * hue) < 1.0)
		res = f1 + (f2 - f1) * 6.0 * hue;
	else if ((2.0 * hue) < 1.0)
		res = f2;
	else if ((3.0 * hue) < 2.0)
		res = f1 + (f2 - f1) * ((2.0 / 3.0) - hue) * 6.0;
	else
		res = f1;
	return res;
}

float3 RGBToHSL( in float3 color )
{
    float3 hsl;  // init to 0 to avoid warnings ? (and reverse if + remove first part)
		
	float fmin = min(min(color.r, color.g), color.b);    //Min. value of RGB
	float fmax = max(max(color.r, color.g), color.b);    //Max. value of RGB
	float delta = fmax - fmin;             //Delta RGB value

	hsl.z = (fmax + fmin) / 2.0; // Luminance

	if (delta == 0.0)		//This is a gray, no chroma...
	{
		hsl.x = 0.0;	// Hue
		hsl.y = 0.0;	// Saturation
	}
	else                                    //Chromatic data...
	{
		if (hsl.z < 0.5)
			hsl.y = delta / (fmax + fmin); // Saturation
		else
			hsl.y = delta / (2.0 - fmax - fmin); // Saturation
		
		float deltaR = (((fmax - color.r) / 6.0) + (delta / 2.0)) / delta;
		float deltaG = (((fmax - color.g) / 6.0) + (delta / 2.0)) / delta;
		float deltaB = (((fmax - color.b) / 6.0) + (delta / 2.0)) / delta;

		if (color.r == fmax )
			hsl.x = deltaB - deltaG; // Hue
		else if (color.g == fmax)
			hsl.x = (1.0 / 3.0) + deltaR - deltaB; // Hue
		else if (color.b == fmax)
			hsl.x = (2.0 / 3.0) + deltaG - deltaR; // Hue

		if (hsl.x < 0.0)
			hsl.x += 1.0; // Hue
		else if (hsl.x > 1.0)
			hsl.x -= 1.0; // Hue
	}
	
	return hsl;
}

float3 HSLToRGB( in float3 hsl )
{
    float3 rgb;

	if (hsl.y == 0.0)
	rgb = float3(hsl.z, hsl.z, hsl.z); // Luminance
	else
	{
		float f2;
		
		if (hsl.z < 0.5)
			f2 = hsl.z * (1.0 + hsl.y);
		else
			f2 = (hsl.z + hsl.y) - (hsl.y * hsl.z);
			
		float f1 = 2.0 * hsl.z - f2;
		
		rgb.r = HueToRGB(f1, f2, hsl.x + (1.0/3.0));
		rgb.g = HueToRGB(f1, f2, hsl.x);
		rgb.b= HueToRGB(f1, f2, hsl.x - (1.0/3.0));
	}
	
	return rgb;
}

float3 KelvinToRGB( in float k )
{
    float3 ret;
    float kelvin     = clamp( k, 1000.0f, 40000.0f ) / 100.0f;
    if( kelvin <= 66.0f )
    {
        ret.r        = 1.0f;
        ret.g        = saturate( 0.39008157876901960784f * log( kelvin ) - 0.63184144378862745098f );
    }
    else
    {
        float t      = max( kelvin - 60.0f, 0.0f );
        ret.r        = saturate( 1.29293618606274509804f * pow( t, -0.1332047592f ));
        ret.g        = saturate( 1.12989086089529411765f * pow( t, -0.0755148492f ));
    }
    if( kelvin >= 66.0f )
        ret.b        = 1.0f;
    else if( kelvin < 19.0f )
        ret.b        = 0.0f;
    else
        ret.b        = saturate( 0.54320678911019607843f * log( kelvin - 10.0f ) - 1.19625408914f );
    return ret;
}

float3 BlendHue(float3 base, float3 blend)
{
	float3 baseHSL = RGBToHSL(base);
	return HSLToRGB(float3(RGBToHSL(blend).r, baseHSL.g, baseHSL.b));
}

float3 BlendSaturation(float3 base, float3 blend)
{
	float3 baseHSL = RGBToHSL(base);
	return HSLToRGB(float3(baseHSL.r, RGBToHSL(blend).g, baseHSL.b));
}

float3 BlendColor(float3 base, float3 blend)
{
	float3 blendHSL = RGBToHSL(blend);
	return HSLToRGB(float3(blendHSL.r, blendHSL.g, RGBToHSL(base).b));
}

float3 BlendLuminosity(float3 base, float3 blend)
{
	float3 baseHSL = RGBToHSL(base);
	return HSLToRGB(float3(baseHSL.r, baseHSL.g, RGBToHSL(blend).b));
}

float4 PackColors(float3 color)
{
	
	return float4(color.rgb, 1);
}

float3 UnpackColors(float4 color)
{
	return color.rgb;
}

float3 cctf_decoding_sRGB(float3 color)
{
	return (color <= 0.04045) ? (color / 12.92) : (powsafe((color + 0.055) / 1.055, 2.4));
}

float3 cctf_encoding_sRGB(float3 color)
{
	return (color <= 0.0031308) ? (color * 12.92) : (1.055 * powsafe(color, 1/2.4) - 0.055);
}

float3 convertOpenDomainToNormalizedLog2(float3 color, float minimum_ev, float maximum_ev)
{
	float in_midgrey = 0.18;

	// remove negative before log transform
	color = max(0.0, color);
	color = (color  < 0.00003051757) ? (0.00001525878 + color) : (color);
	color = clamp(
		log2(color / in_midgrey),
		float3(minimum_ev, minimum_ev, minimum_ev),
		float3(maximum_ev,maximum_ev,maximum_ev)
	);
	float total_exposure = maximum_ev - minimum_ev;

	return (color - minimum_ev) / total_exposure;
}


// F_MATRIX //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 

// ACES
static const float3x3 ACESInputMat = float3x3
(
	0.59719, 0.35458, 0.04823,
	0.07600, 0.90834, 0.01566,
	0.02840, 0.13383, 0.83777
);


static const float3x3 ACESOutputMat = float3x3
(
	 1.60475, -0.53108, -0.07367,
	-0.10208,  1.10813, -0.00605,
	-0.00327, -0.07276,  1.07602
);

float3 RRTAndODTFit(float3 v)
{
	float3 a = v * (v + 0.0245786f) - 0.000090537f;
	float3 b = v * (0.983729f * v + 0.4329510f) + 0.238081f;
	return a / b;
}

// AGX 
static const float3x3 agx_compressed_matrix = float3x3(
	0.84247906, 0.0784336, 0.07922375,
	0.04232824, 0.87846864, 0.07916613,
	0.04237565, 0.0784336, 0.87914297
);

static const float3x3 agx_compressed_matrix_inverse = float3x3(
	1.1968790, -0.09802088, -0.09902975,
	-0.05289685, 1.15190313, -0.09896118,
	-0.05297163, -0.09804345, 1.15107368
);


// F_NORMALS //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 

float3 GetPosition(float2 coords)
{
	float EyeDepth = GetLinearDepth(coords.xy)*FAR_PLANE;
	return float3((coords.xy * 2.0 - 1.0)*EyeDepth,EyeDepth);
}

float3 GetNormalFromDepth(float2 coords) 
{
	float3 centerPos = GetPosition(coords.xy);
	float2 offs = BUFFER_PIXEL_SIZE*1.0;
	
	float3 ddx1 = GetPosition(coords.xy + float2(offs.x, 0)) - centerPos;
	float3 ddx2 = centerPos - GetPosition(coords.xy + float2(-offs.x, 0));

	float3 ddy1 = GetPosition(coords.xy + float2(0, offs.y)) - centerPos;
	float3 ddy2 = centerPos - GetPosition(coords.xy + float2(0, -offs.y));

	ddx1 = lerp(ddx1, ddx2, abs(ddx1.z) > abs(ddx2.z));
	ddy1 = lerp(ddy1, ddy2, abs(ddy1.z) > abs(ddy2.z));

	float3 normal = cross(ddy1, ddx1);
	
	return normalize(normal);
}

float3 GetNormalFromColor(float2 coords, float2 offset, float scale, float sharpness)
{
	const float3 lumCoeff = Luma709;

	float hpx = dot(tex2Dlod(ReShade::BackBuffer, float4(coords + float2(offset.x,0.0),0,0)).xyz,lumCoeff) * scale;
	float hmx = dot(tex2Dlod(ReShade::BackBuffer, float4(coords - float2(offset.x,0.0),0,0)).xyz,lumCoeff) * scale;
	float hpy = dot(tex2Dlod(ReShade::BackBuffer, float4(coords + float2(0.0,offset.y),0,0)).xyz,lumCoeff) * scale;
	float hmy = dot(tex2Dlod(ReShade::BackBuffer, float4(coords - float2(0.0,offset.y),0,0)).xyz,lumCoeff) * scale;

	float dpx = GetLinearDepth(coords + float2(offset.x,0.0));
	float dmx = GetLinearDepth(coords - float2(offset.x,0.0));
	float dpy = GetLinearDepth(coords + float2(0.0,offset.y));
	float dmy = GetLinearDepth(coords - float2(0.0,offset.y));

	float2 xymult = float2(abs(dmx - dpx), abs(dmy - dpy)) * sharpness; 
	xymult = max(0.0, 1.0 - xymult);
    	
	float ddx = (hmx - hpx) / (2.0 * offset.x) * xymult.x;
	float ddy = (hmy - hpy) / (2.0 * offset.y) * xymult.y;

	return normalize(float3(ddx, ddy, 1.0));
}

float3 GetBlendedNormals(float3 n1, float3 n2)
{
	 return normalize(float3(n1.xy*n2.z + n2.xy*n1.z, n1.z*n2.z));
}


// F_DOF //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 

float GetCoC(float2 coords)
{
	if (!bUseDOF || kHome) return 0;
	else 
	{
		float scenedepth = LDepth(coords);
		float scenefocus, scenecoc = 0.0;

		scenefocus = 0.0;
		//bool bFreeze;
		
		float2 focusPoint; 
			if (iDOFfocus == 1 && LeftMouseDown == 0) 
			{
				focusPoint = LeftMouseDown ? MouseCoords * BUFFER_PIXEL_SIZE : focusPoint;
				//bFreeze = LeftMouseDown ? true : false;
			}
			
			else 
			{
				focusPoint = DOF_FOCUSPOINT;
				//bFreeze = false;
			}

		[loop]
		for (int r = 6; 0 < r; r--)
		{
			sincos((6.2831853 / 6) * r, coords.y, coords.x);
			coords.y *= BUFFER_ASPECT_RATIO;
			scenefocus += LDepth(coords * 0.05 + focusPoint);
		}
		scenefocus /= 6;
		
		scenefocus = smootherstep(0.0, DOF_INFINITEFOCUS, scenefocus);
		scenedepth = smootherstep(0.0, DOF_INFINITEFOCUS, scenedepth);

		float farBlurDepth = scenefocus * pow(4.0, DOF_FARBLURCURVE);

		if (scenedepth < scenefocus)
		{
			scenecoc = (scenedepth - scenefocus) / scenefocus;
		}
		else
		{
			scenecoc = (scenedepth - scenefocus) / (farBlurDepth - scenefocus);
			scenecoc = saturate(scenecoc);
		}
	
		scenecoc = saturate(scenecoc * 0.5 + 0.5);

		return scenecoc;
	}
}

float3 BrightBokeh(float3 c)
{
    float3 bC = max(c - float3(fBokehLuminance, fBokehLuminance, fBokehLuminance), 0.0);
    float bright = dot(bC, 1.0);
    bright = smootherstep(0.0f, 0.5, bright);
    return lerp(0.0, c, bright);
}

float4 GetMatsoDOFCA(sampler col, float2 tex, float CoC)
{
	float3 chroma = pow(float3(0.5, 1.0, 1.5), fMatsoDOFChromaPow * CoC);

	float2 tr = ((2.0 * tex - 1.0) * chroma.r) * 0.5 + 0.5;
	float2 tg = ((2.0 * tex - 1.0) * chroma.g) * 0.5 + 0.5;
	float2 tb = ((2.0 * tex - 1.0) * chroma.b) * 0.5 + 0.5;
	
	float3 color = float3(tex2Dlod(col, float4(tr,0,0)).r, tex2Dlod(col, float4(tg,0,0)).g, tex2Dlod(col, float4(tb,0,0)).b) * (1.0 - CoC);
	
	return float4(color, 1.0);
}

float4 GetMatsoDOFBlur(int axis, float2 coord, sampler SamplerHDRX)
{
	float4 blurcolor = tex2D(SamplerHDRX, coord.xy);

	float centerDepth = blurcolor.w;
	float blurAmount = abs(centerDepth * 2.0 - 1.0);
	float discRadius = blurAmount * lerp(DOF_BLURRADIUS*0.5, DOF_BLURRADIUS+(DOF_BLURRADIUS/fDOFAperture), LDepth(coord));

	discRadius*=(centerDepth < 0.5) ? (1.0 / max(DOF_NEARBLURCURVE * 2.0, 1.0)) : 1.0;

	blurcolor = 0.0;

	float2 tdirs[4] = { float2(1.0, 0.0), float2(0.0, 1.0), float2(0.707, 0.707), float2(-0.707, 0.707) };

	for (int i = -4; i < 4; i++)
	{
		float2 taxis =  tdirs[axis];

		taxis.x = cos(fMatsoDOFBokehAngle * 0.0175) * taxis.x - sin(fMatsoDOFBokehAngle * 0.0175) * taxis.y;
		taxis.y = sin(fMatsoDOFBokehAngle * 0.0175) * taxis.x + cos(fMatsoDOFBokehAngle * 0.0175) * taxis.y;
		
		float2 tcoord = coord.xy + (float)i * taxis * discRadius * BUFFER_PIXEL_SIZE * 0.5 / 4;

		float4 ct = GetMatsoDOFCA(SamplerHDRX, tcoord.xy, discRadius * BUFFER_RCP_WIDTH * 0.5 / 4);

		float3 bct = BrightBokeh(ct.rgb);
		float b = dot(ct.rgb, float3(0.3, 0.59, 0.11)) + dot(bct, bct) + 0.1;
		float w = powsafe(b*fBokehIntensity, fMatsoDOFBokehCurve);

		blurcolor.xyz += ct.xyz * w;
		blurcolor.w += w;
	}

	blurcolor.xyz /= blurcolor.w;
	blurcolor.w = centerDepth;
	return blurcolor;
}


// F_LUT //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 

float3 LUT(float3 ColorIn, sampler SamplerLut, float Intensity)
{
	float3 lut3D = ColorIn*(LUT_BLOCK_SIZE-1);
	float2 lut2D[2];
		// Front
		lut2D[0].x = floor(lut3D.z)*LUT_BLOCK_SIZE+lut3D.x;
		lut2D[0].y = lut3D.y;
		// Back
		lut2D[1].x = ceil(lut3D.z)*LUT_BLOCK_SIZE+lut3D.x;
		lut2D[1].y = lut3D.y;
	lut2D[0] = (lut2D[0]+0.5)*LUT_PIXEL_SIZE;
	lut2D[1] = (lut2D[1]+0.5)*LUT_PIXEL_SIZE;

	float3 LutColor = lerp(
			tex2D(SamplerLut, lut2D[0]).rgb, // Front Z
			tex2D(SamplerLut, lut2D[1]).rgb, // Back Z
			frac(lut3D.z)
		);

	return lerp( ColorIn, LutColor, Intensity);
}

float3 LUT_CL(float3 ColorIn, sampler SamplerLut, float2 Intensity)
{
	float3 lut3D = ColorIn*(LUT_BLOCK_SIZE-1);
	float2 lut2D[2];
		// Front
		lut2D[0].x = floor(lut3D.z)*LUT_BLOCK_SIZE+lut3D.x;
		lut2D[0].y = lut3D.y;
		// Back
		lut2D[1].x = ceil(lut3D.z)*LUT_BLOCK_SIZE+lut3D.x;
		lut2D[1].y = lut3D.y;
	lut2D[0] = (lut2D[0]+0.5)*LUT_PIXEL_SIZE;
	lut2D[1] = (lut2D[1]+0.5)*LUT_PIXEL_SIZE;

	float3 LutColor = lerp(
			tex2D(SamplerLut, lut2D[0]).rgb, // Front Z
			tex2D(SamplerLut, lut2D[1]).rgb, // Back Z
			frac(lut3D.z)
		);

	if ( all(Intensity==1.0) )
		ColorIn = LutColor;
	else
	{
		ColorIn = lerp(
			normalize(ColorIn),
			normalize(LutColor),
			Intensity.x
		)*lerp(
			length(ColorIn),
			length(LutColor),
			Intensity.y
		);
	}
	
	return ColorIn;
}


// F_TONEMAP //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 
// TONEMAP REINHARD
float3 reinhard(float3 color)
{
	return color / (1.0 + color);
}

float3 HaarmPeterDuikerFilmicToneMapping(float3 color)
{
    	color = max( (float3)0.0f, color - 0.004f );
    	return pow( abs( ( color * ( 6.2f * color + 0.5f ) ) / ( color * ( 6.2f * color + 1.7f ) + 0.06 ) ), 2.2f );
}

// TONEMAP ACES
float3 ACESFitted(float3 color)
{
	color = mul(ACESInputMat, color);
	color = RRTAndODTFit(color);
	color = mul(ACESOutputMat, color);
	color = saturate(color);
	
	return color;
}

//TONEMAP FILMIC
float3 WatchDog(float3 col, float exposure) {
    const float3 A = float3(0.55f, 0.50f, 0.45f);	// Shoulder strength
	const float3 B = float3(0.30f, 0.27f, 0.22f);	// Linear strength
	const float3 C = float3(0.10f, 0.10f, 0.10f);	// Linear angle
	const float3 D = float3(0.10f, 0.07f, 0.03f);	// Toe strength
	const float3 E = float3(0.01f, 0.01f, 0.01f);	// Toe Numerator
	const float3 F = float3(0.30f, 0.30f, 0.30f);	// Toe Denominator
	const float3 W = float3(2.80f, 2.90f, 3.10f);	// Linear White Point Value

    col *= exposure;

    static const float white = ((W * (A * W + C * B) + D * E) / (W * (A * W + B) + D * F)) - (E / F);
	col = ((col * (A * col + C * B) + D * E) / (col * (A * col + B) + D * F)) - (E / F);

    return col;
}

float3 JohnHable(float3 col, float exposure) {
    static const float A = 0.15; //shoulder strength
    static const float B = 0.50; //linear strength
	static const float C = 0.10; //linear angle
	static const float D = 0.20; //toe strength
	static const float E = 0.02; //toe numerator
	static const float F = 0.30; //toe denominator
	static const float W = 11.2; //linear white point value

    col *= exposure;

    col = ((col * (A * col + C * B) + D * E) / (col * (A * col + B) + D * F)) - E / F;
    static const float white = 1.0 / (((W * (A * W + C * B) + D * E) / (W * (A * W + B) + D * F)) - E / F);
    col *= white;
    return col;
}

float3 PP2( float3 color )
{
	float	grayadaptation = GetLuma(color);
	grayadaptation = clamp(grayadaptation, 0, 50);

	color.xyz =  color.xyz / (grayadaptation * 50.0 + clamp(FNumber*0.1, 0.1, 1.0)); //EAdaptationMaxV2
	float3 xncol = normalize( color.xyz);
	float3 scl =  color.xyz / xncol.xyz;
	scl = pow(scl, 1.0); //EIntensityContrastV2
	xncol.xyz = pow(xncol.xyz, 1.0); //EColorSaturationV2
	color.xyz = scl*xncol.xyz;
	float	lumamax = 1000.0; // EToneMappingOversaturationV2
	color.xyz = ( color.xyz * (1.0 +  color.xyz / lumamax)) / ( color.xyz + fGammaIn); //EToneMappingCurveV2
 	color.xyz*=4;

	return color;

}

// AGX 
float3 AGX_AIO(float3 Image)
{
	//PreTonemapp
	Image = cctf_decoding_sRGB(Image);
	float ImageLuma = powsafe(GetLuma(Image), INPUT_HIGHLIGHT_GAIN_GAMMA);
	Image += Image * ImageLuma.xxx * INPUT_HIGHLIGHT_GAIN;
	Image = powsafe(Image,fAGXGamma);
	Image *= powsafe(2.0, Exposure);
	
	//AGX
	Image = max(0.0, Image); // clamp negatives
	Image = mul(agx_compressed_matrix, Image);
	Image = convertOpenDomainToNormalizedLog2(Image, -10.0, 6.5);
	Image = clamp(Image, 0.0, 1.0);
	
	//LUT
	Image = LUT(Image, AGXLUTSampler, 1.0f);
	Image = cctf_decoding_pow2_2(Image);
	
	//OUT
	float3 ImageOutset = mul(agx_compressed_matrix_inverse, Image);
	Image = lerp(Image, ImageOutset, fAGXHLSat);
	return cctf_encoding_pow2_2(Image);
}

// TONEMAPPER
float get_adapt()
{
	int AdaptPrecision;

	if (AdaptMetering == 0) AdaptPrecision = 0;
	if (AdaptMetering == 1) AdaptPrecision = 4;
	if (AdaptMetering == 2) AdaptPrecision = 9;
	
	return (AdaptMetering > 0 ) ? tex2Dlod(Small,float4(AdaptFocalPoint, 0, AdaptMipLevels - AdaptPrecision)).x :
		tex2Dlod(Small,float4(perfectCenter, 0, AdaptMipLevels - AdaptPrecision)).x;
}

float3 tonemap(float3 color, float exposure)
{
	color = powsafe(color, 1.0/fGammaIn);
	
	if(iTonemapCam == 1) color = ACESFitted(color * exposure);
	if(iTonemapCam == 2) color = reinhard(color * exposure);
	if(iTonemapCam == 3) color = WatchDog(color, exposure);
	if(iTonemapCam == 4) color = JohnHable(color, exposure);
	if(iTonemapCam == 5) color = HaarmPeterDuikerFilmicToneMapping(color * exposure);
	if(iTonemapCam == 6) color = PP2(color * exposure);

	return powsafe(color, fGammaIn);
}


// F_DITHER //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 

float3 TriDither(float3 color, float2 uv, int bits)
{
    float bitstep = exp2(bits) - 1.0;
    float lsb = 1.0 / bitstep;
    float lobit = 0.5 / bitstep;
    float hibit = (bitstep - 0.5) / bitstep;

    float3 m = float3(uv, rand21(uv + (Timer * 0.001))) + 1.0;
    float h = permute(permute(permute(m.x) + m.y) + m.z);

    float3 noise1, noise2;
    noise1.x = rand11(h); h = permute(h);
    noise2.x = rand11(h); h = permute(h);
    noise1.y = rand11(h); h = permute(h);
    noise2.y = rand11(h); h = permute(h);
    noise1.z = rand11(h); h = permute(h);
    noise2.z = rand11(h);

    float3 lo = saturate(remap(color.xyz, 0.0, lobit));
    float3 hi = saturate(remap(color.xyz, 1.0, hibit));
    float3 uni = noise1 - 0.5;
    float3 tri = noise1 - noise2;
	return lerp(uni, tri, min(lo, hi)) * lsb;
}

float remap_tri( float v )
{
    // Convert uniform distribution into triangle-shaped distribution.
    float orig = v*2.0 - 1.0;
    v = orig / sqrt( abs(orig) );
    v = max(-1.0, v); // Nerf the NaN generated by 0*rsqrt(0). Thanks @FioraAeterna!
    v = v - sign(orig);// + 0.5; // GPUs round!

    return v;
}

float3 remap_tri( float3 c )
{
    return float3( remap_tri(c.r), remap_tri(c.g), remap_tri(c.b) );
}

float3 ScreenSpaceDitherTri( float2 vScreenPos : SV_POSITION ) : SV_Target
{   
    float3 vDither = dot( float2( 131.0, 312.0 ), vScreenPos.xy);
    vDither.rgb = frac( vDither.rgb / float3( 103.0, 71.0, 97.0 ) );
    vDither = remap_tri( vDither.rgb );
    return vDither.rgb; 
}

float interleaved_gradient(float2 uv : SV_POSITION) : SV_Target
{
    float3 magic = float3(0.06711056, 0.00583715, 52.9829189);
    return frac(magic.z * frac(dot(uv, magic.xy)));
}

float3 ign3(float2 uv : SV_POSITION) : SV_Target {
  float3 dither = interleaved_gradient(uv.xy);
  dither.y = interleaved_gradient(uv.xy + 0.5);
  return dither;
}

// LETTERBOX 
float3 BorderPass( float3 colorInput, float2 tex )
{
	if (LDepth(tex) < 0.01 || fLBox == 0.0) return colorInput;
	else 
	{
		float4 Bars = 0.0;
		Bars.x = abs(tex.y*2.0-1.0) - fLBox;
		if (Bars.x >= 0.0)  
		{
			colorInput.xyz *= 0.0; 
			return colorInput; 
		}
		else
		{
			return colorInput; 
		}
	}

	return colorInput;
}


		/*////////////////////////////////////////////////////////////////////////////////////////////////////
		//////////////////////////////////////////////////////////////////////////////////////////////////////
		
		//										VERTEX_SHADERS 
		
		//////////////////////////////////////////////////////////////////////////////////////////////////////
		////////////////////////////////////////////////////////////////////////////////////////////////////*/
// TONEMAPPER
void PostProcessVST(
	uint id : SV_VERTEXID,
	out float4 p : SV_POSITION,
	out float2 uv : TEXCOORD)
{
	uv.x = (id == 2) ? 2.0 : 0.0;
	uv.y = (id == 1) ? 2.0 : 0.0;
	p = float4(uv * float2(2.0, -2.0) + float2(-1.0, 1.0), 0.0, 1.0);
}

void TonemapperVST(uint id : SV_VERTEXID,out float4 p : SV_POSITION,out float2 uv : TEXCOORD0,out float inv_white : TEXCOORD1,out float exposure : TEXCOORD2)
{
	PostProcessVST(id, p, uv);

	exposure = exp2(Exposure);
	float adapt = get_adapt();
	float fMin = clamp(FNumber*0.1, 0.1, 1.0);
	if (kInsert) fMin *= 1.8;
	adapt = clamp(adapt, fMin, 50.0);
	exposure /= adapt;

	inv_white = lerp(1.0, rcp(tonemap(1.0, exposure).x), fTPWhite);
}

		/*////////////////////////////////////////////////////////////////////////////////////////////////////
		//////////////////////////////////////////////////////////////////////////////////////////////////////
		
		//										PIXEL_SHADERS 
		
		//////////////////////////////////////////////////////////////////////////////////////////////////////
		////////////////////////////////////////////////////////////////////////////////////////////////////*/

		/*//////////////////////////////////////////////////////////////////////////////////////////////////// 
		//										PS_ENVIRONMENTS
		////////////////////////////////////////////////////////////////////////////////////////////////////*/
		

// PS_Environment //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#define BlackPoint -5
#define WhitePoint 255+iNBTS
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 

float3 PS_Environment(float4 position : SV_Position, float2 texcoord : TexCoord) : SV_Target
{
	float4 color = tex2D(ReShade::BackBuffer, texcoord);
	
	// contrast input
	if (fCtrstIN != 0.0 && bENABLE_CAMERA) color = saturate(LUT(color, CtrstDownLUTSampler, fCtrstIN-(fCtrstIN*2.0))); 

	if (bENABLE_ENV && !kInsert)
	{
		// Sky
		float3 colorSky = color;
		
		if(iShowSkyMask != 2 && bSkyControl) 
		{
			colorSky = (skyExposure != 0.0) ? lerp(color.rgb, powsafe(color, 1.0/2.2), skyExposure*0.75) : colorSky;
			colorSky.b = (skyBlueShift != 0.0) ? lerp(colorSky.b, pow(colorSky.b,0.75f), skyBlueShift) : colorSky.b;
			
			float DarkColorThreshold = bskyColorLuma ? (Luma709/255.0)+0.0001 : (skyColorThreshold/255.0)+0.0001;
			float mix = getAvgColor(color.rgb);
			
			float mask = lerp(0.0, lerp(0.0,1.0,smootherstep(DarkColorThreshold-(DarkColorThreshold*0.2),DarkColorThreshold+(DarkColorThreshold*0.2),mix)), getSkyMask(texcoord));
			color = (bskySoftExp) ? lerp(color, SoftLight(color, (colorSky-color)+0.5), mask) :	lerp(color, colorSky, mask);

			if (iShowSkyMask==1) color *= getSkyMask(texcoord);
		}
		
		// Nothing brighter than the sky
		if (iNBTS > 0 && iShowSkyMask != 1 && bSkyControl) 
		{
			float black_point_float = BlackPoint / 255.0;
			float white_point_float = (255.0 / (WhitePoint - BlackPoint));

			float3 NBTScolor = color;
			NBTScolor = NBTScolor * white_point_float - (black_point_float *  white_point_float);

			color = lerp(color.rgb, NBTScolor, getLandMask(texcoord));
			if (iShowSkyMask==2) color *= getLandMask(texcoord);
		}
		
		//fog
		if (bFogControl) 
		{
			float3 fogColor = powsafe(color, fogCompression);
			fogColor.b =  (fogBlueShift != 0) ? lerp(fogColor.b, powsafe(fogColor.b,0.75f), fogBlueShift) : fogColor.b;
			color = lerp(color.rgb, fogColor, saturate(getFogMask(texcoord)));
			
			if (fogPushDepth.x != 0 && bFogPush) 
			{
				float fogluma = GetLuma(color.rgb);
				float3 fogChroma = color.rgb - fogluma;
				float3 fogCcontrast = fogluma;

				fogCcontrast=lerp(fogCcontrast, (fogCcontrast * (1-(fogPushDepth.x*0.1))) + (fogPushDepth.x*0.1), getFogPushMask(texcoord));
				color = lerp(color, fogCcontrast+fogChroma,getFogPushMask(texcoord));	
				
			}
			
			if (iShowFogMask==1) color *= getFogMask(texcoord);
			if (iShowFogMask==2) color *= getFogPushMask(texcoord);
		}
	}
	
	// Debug
	if (bShowDepth) color = LDepth(texcoord);
	if (iShowGiMask==1) color = getGiMask(texcoord);
	
	return color;
}


// PS_NORMALS //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 

void GBuffer1(float4 vpos : SV_Position, float2 texcoord : TexCoord, out float4 normal : SV_Target0, out float roughness : SV_Target1) 
{
	normal.rgb = GetNormalFromDepth(texcoord.xy);
	normal.a   = LDepth(texcoord.xy);
	
}

float4 SNH(float4 vpos : SV_Position, float2 texcoord : TexCoord) : SV_Target
{
	float4 color = tex2D(sSSSR_NormTex, texcoord);

	if (!bGiControl && fIBLIntensity <= 0.01 && !bENABLE_ENV) return 0.0;
	else {		
	
		float4 s, s1; float sc;
		
		float2 p = pix; p*=SNWidth;
		
		float T = SNThreshold * saturate(2*(1-color.a));
		T = rcp(max(T, 0.0001));
		
		for (int i = -SNSamples; i <= SNSamples; i++)
		{
			s = tex2D(sSSSR_NormTex, float2(texcoord + float2(i*p.x, 0)/*, 0, LODD*/));
			float diff = dot(0.333, abs(s.rgb - color.rgb)) + abs(s.a - color.a)*SNDepthW;
			diff = 1-saturate(diff*T);
			s1 += s*diff;
			sc += diff;
		}
		
		return float4(normalize(s1.rgb), s1.a);
	}
}

float4 SNV(float4 vpos : SV_Position, float2 texcoord : TexCoord) : SV_Target
{
	float4 color = tex2Dlod(sSSSR_NormTex, float4(texcoord, 0, 0));
	
	if (!bGiControl && fIBLIntensity <= 0.01 && !bENABLE_ENV) return 0.0;
	else {
		float4 s, s1; float sc;

		float2 p = pix; p*=SNWidth;
		float T = SNThreshold * saturate(2*(1-color.a)); T = rcp(max(T, 0.0001));
		for (int i = -SNSamples; i <= SNSamples; i++)
		{
			s = tex2D(sSSSR_NormTex, float2(texcoord + float2(0, i*p.y)/*, 0, LODD*/));
			float diff = dot(0.333, abs(s.rgb - color.rgb)) + abs(s.a - color.a)*SNDepthW;
			diff = 1-saturate(diff*T*2);
			s1 += s*diff;
			sc += diff;
		}
		
		s1.rgba = float4(normalize(s1.rgb), s1.a);
		return float4(s1.rgb, LDepth(texcoord));
	}
}


// PS_AMBIANT_GI ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#define giThreshold 0.1
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void PS_GI_DetectInt(float4 vpos : SV_Position, float2 texcoord : TEXCOORD, out float4 detectInt : SV_Target0)
{
	detectInt = tex2D(ReShade::BackBuffer, texcoord);
}

void PS_GI_DetectLow(float4 vpos : SV_Position, float2 texcoord : TEXCOORD, out float4 detectLow : SV_Target0)
{
	detectLow = 0;
	if (bGiControl && fAmbIntensity > 0.01 && bENABLE_ENV)
	{	
		if (texcoord.x != 0.5 && texcoord.y != 0.5)
			discard;

		[loop]
		for (float i = 0.0; i <= 1; i += 0.03125)
		{
			[unroll]
			for (float j = 0.0; j <= 1; j += 0.03125)
			{
				detectLow.xyz += tex2D(GidetectIntColor, float2(i, j)).xyz;
			}
		}

		detectLow.xyz /= 32 * 32;
	}
}

void PS_GI_DetectHigh(float4 vpos : SV_Position, float2 texcoord : TEXCOORD, out float4 x : SV_Target)
{
	x = tex2D(ReShade::BackBuffer, texcoord);
	
	if (bGiControl && fAmbIntensity > 0.01 && bENABLE_ENV) 
	{
		x = float4(x.rgb * pow(abs(max(x.r, max(x.g, x.b))), 2.0), 1.0f);

		float base = (x.r + x.g + x.b); base /= 3;

		float nR = (x.r * 2) - base;
		float nG = (x.g * 2) - base;
		float nB = (x.b * 2) - base;

		[flatten]
		if (nR < 0)
		{
			nG += nR / 2;
			nB += nR / 2;
			nR = 0;
		}
		[flatten]
		if (nG < 0)
		{
			nB += nG / 2;
			[flatten] if (nR > -nG / 2) nR += nG / 2; else nR = 0;
			nG = 0;
		}
		[flatten]
		if (nB < 0)
		{
			[flatten] if (nR > -nB / 2) nR += nB / 2; else nR = 0;
			[flatten] if (nG > -nB / 2) nG += nB / 2; else nG = 0;
			nB = 0;
		}

		[flatten]
		if (nR > 1)
		{
			nG += (nR - 1) / 2;
			nB += (nR - 1) / 2;
			nR = 1;
		}
		[flatten]
		if (nG > 1)
		{
			nB += (nG - 1) / 2;
			[flatten] if (nR + (nG - 1) < 1) nR += (nG - 1) / 2; else nR = 1;
			nG = 1;
		}
		[flatten]
		if (nB > 1)
		{
			[flatten] if (nR + (nB - 1) < 1) nR += (nB - 1) / 2; else nR = 1;
			[flatten] if (nG + (nB - 1) < 1) nG += (nB - 1) / 2; else nG = 1;
			nB = 1;
		}

		x.r = nR; x.g = nG; x.b = nB;
	}
}

void PS_GI_HGB(float4 vpos : SV_Position, float2 texcoord : TEXCOORD, out float4 hgb : SV_Target)
{
	if (!bGiControl || fAmbIntensity < 0.01 || !bENABLE_ENV) hgb = tex2D(ReShade::BackBuffer, texcoord);
	else 
	{
		const float sampleOffsets[5] = { 0.0, 2.4347826, 4.3478260, 6.2608695, 8.1739130 };
		const float sampleWeights[5] = { 0.16818994, 0.27276957, 0.111690125, 0.024067905, 0.0021112196 };

		hgb = tex2D(GiInColor, texcoord) * sampleWeights[0];
		hgb = float4(max(hgb.rgb - giThreshold, 0.0), hgb.a);
		float stepMult = 1.08 + (Gi_timer.x / 100) * 0.02;

		[flatten]
		if ((texcoord.x + sampleOffsets[1] * LHGI_PIXEL_SIZE.x) < 1.05)
			hgb += tex2D(GiInColor, texcoord + float2(sampleOffsets[1] * LHGI_PIXEL_SIZE.x, 0.0)) * sampleWeights[1] * stepMult;
		[flatten]
		if ((texcoord.x - sampleOffsets[1] * LHGI_PIXEL_SIZE.x) > -0.05)
			hgb += tex2D(GiInColor, texcoord - float2(sampleOffsets[1] * LHGI_PIXEL_SIZE.x, 0.0)) * sampleWeights[1] * stepMult;

		[flatten]
		if ((texcoord.x + sampleOffsets[2] * LHGI_PIXEL_SIZE.x) < 1.05)
			hgb += tex2D(GiInColor, texcoord + float2(sampleOffsets[2] * LHGI_PIXEL_SIZE.x, 0.0)) * sampleWeights[2] * stepMult;
		[flatten]
		if ((texcoord.x - sampleOffsets[2] * LHGI_PIXEL_SIZE.x) > -0.05)
			hgb += tex2D(GiInColor, texcoord - float2(sampleOffsets[2] * LHGI_PIXEL_SIZE.x, 0.0)) * sampleWeights[2] * stepMult;

		[flatten]
		if ((texcoord.x + sampleOffsets[3] * LHGI_PIXEL_SIZE.x) < 1.05)
			hgb += tex2D(GiInColor, texcoord + float2(sampleOffsets[3] * LHGI_PIXEL_SIZE.x, 0.0)) * sampleWeights[3] * stepMult;
		[flatten]
		if ((texcoord.x - sampleOffsets[3] * LHGI_PIXEL_SIZE.x) > -0.05)
			hgb += tex2D(GiInColor, texcoord - float2(sampleOffsets[3] * LHGI_PIXEL_SIZE.x, 0.0)) * sampleWeights[3] * stepMult;

		[flatten]
		if ((texcoord.x + sampleOffsets[4] * LHGI_PIXEL_SIZE.x) < 1.05)
			hgb += tex2D(GiInColor, texcoord + float2(sampleOffsets[4] * LHGI_PIXEL_SIZE.x, 0.0)) * sampleWeights[4] * stepMult;
		[flatten]
		if ((texcoord.x - sampleOffsets[4] * LHGI_PIXEL_SIZE.x) > -0.05)
			hgb += tex2D(GiInColor, texcoord - float2(sampleOffsets[4] * LHGI_PIXEL_SIZE.x, 0.0)) * sampleWeights[4] * stepMult;
	}
}

void PS_GI_VGB(float4 vpos : SV_Position, float2 texcoord : TEXCOORD, out float4 vgb : SV_Target)
{
	
	if (!bGiControl || fAmbIntensity < 0.01 || !bENABLE_ENV) vgb = tex2D(ReShade::BackBuffer, texcoord);
	else 
	{
		const float sampleOffsets[5] = { 0.0, 2.4347826, 4.3478260, 6.2608695, 8.1739130 };
		const float sampleWeights[5] = { 0.16818994, 0.27276957, 0.111690125, 0.024067905, 0.0021112196 };

		vgb = tex2D(GiOutColor, texcoord) * sampleWeights[0];
		vgb = float4(max(vgb.rgb - giThreshold, 0.0), vgb.a);
		float stepMult = 1.08 + (Gi_timer.x / 100) * 0.02;

		[flatten]
		if ((texcoord.y + sampleOffsets[1] * LHGI_PIXEL_SIZE.y) < 1.05)
			vgb += tex2D(GiOutColor, texcoord + float2(0.0, sampleOffsets[1] * LHGI_PIXEL_SIZE.y)) * sampleWeights[1] * stepMult;
		[flatten]
		if ((texcoord.y - sampleOffsets[1] * LHGI_PIXEL_SIZE.y) > -0.05)
			vgb += tex2D(GiOutColor, texcoord - float2(0.0, sampleOffsets[1] * LHGI_PIXEL_SIZE.y)) * sampleWeights[1] * stepMult;

		[flatten]
		if ((texcoord.y + sampleOffsets[2] * LHGI_PIXEL_SIZE.y) < 1.05)
			vgb += tex2D(GiOutColor, texcoord + float2(0.0, sampleOffsets[2] * LHGI_PIXEL_SIZE.y)) * sampleWeights[2] * stepMult;
		[flatten]
		if ((texcoord.y - sampleOffsets[2] * LHGI_PIXEL_SIZE.y) > -0.05)
			vgb += tex2D(GiOutColor, texcoord - float2(0.0, sampleOffsets[2] * LHGI_PIXEL_SIZE.y)) * sampleWeights[2] * stepMult;

		[flatten]
		if ((texcoord.y + sampleOffsets[3] * LHGI_PIXEL_SIZE.y) < 1.05)
			vgb += tex2D(GiOutColor, texcoord + float2(0.0, sampleOffsets[3] * LHGI_PIXEL_SIZE.y)) * sampleWeights[3] * stepMult;
		[flatten]
		if ((texcoord.y - sampleOffsets[3] * LHGI_PIXEL_SIZE.y) > -0.05)
			vgb += tex2D(GiOutColor, texcoord - float2(0.0, sampleOffsets[3] * LHGI_PIXEL_SIZE.y)) * sampleWeights[3] * stepMult;

		[flatten]
		if ((texcoord.y + sampleOffsets[4] * LHGI_PIXEL_SIZE.y) < 1.05)
			vgb += tex2D(GiOutColor, texcoord + float2(0.0, sampleOffsets[4] * LHGI_PIXEL_SIZE.y)) * sampleWeights[4] * stepMult;
		[flatten]
		if ((texcoord.y - sampleOffsets[4] * LHGI_PIXEL_SIZE.y) > -0.05)
			vgb += tex2D(GiOutColor, texcoord - float2(0.0, sampleOffsets[4] * LHGI_PIXEL_SIZE.y)) * sampleWeights[4] * stepMult;
	}
}

float4 PS_GI_Mix(float4 vpos : SV_Position, float2 texcoord : TEXCOORD) : SV_Target
{
	float4 color = tex2D(ReShade::BackBuffer, texcoord);
	float4 GIcolor = color;

	color = (iShowGiMask == 2) ? float4(tex2D(sSSSR_NormTex, texcoord)) : color;
	
	if (!bGiControl || (iShowFogMask > 0 || iShowSkyMask > 0) || !bENABLE_ENV) return color;
	else 
	{
		float  scenedepth 		= GetLinearDepth(texcoord.xy);
		float3 bump = 0.0;
		float4 Geometry  		= tex2D(sSSSR_NormTex, texcoord);
		float3 SurfaceNormals 	= Geometry.xyz;
		float3 TextureNormals 	= GetNormalFromColor(texcoord.xy, 0.01 * BUFFER_PIXEL_SIZE / scenedepth, 0.0002 / scenedepth + 0.1, 1000.0);
		float3 SceneNormals		= GetBlendedNormals(SurfaceNormals, TextureNormals);

		SceneNormals 				= normalize(lerp(SurfaceNormals, SceneNormals, lerp(0.02, 0.2, getGiMask(texcoord)))); //textures
		float3 ScreenSpacePosition 	= GetPosition(texcoord.xy);
		float3 ViewDirection 		= normalize(ScreenSpacePosition.xyz);	

			if (fAmbIntensity >= 0.01) 
			{
				
				float4 high = tex2D(GiInColor, texcoord);
				high = min(0.0325f, high) * 1.15f;

				float4 highSampleMix = (1.0 - ((1.0 - GIcolor) * (1.0 - high * 1.0)));

				float fBloomIntensity = iGiBlendMethod > 0 ? fAmbIntensity*1.5 : fAmbIntensity;
				
				float4 baseSample = lerp(GIcolor, highSampleMix, fBloomIntensity);
				float baseSampleMix = lerp(baseSample.r + baseSample.g + baseSample.b, SceneNormals, fRadPrecision);
				
				GIcolor = saturate(lerp(GIcolor, highSampleMix, max(0.0f, fBloomIntensity*0.85f) * baseSampleMix));
			}
			
			if (fIBLIntensity >= 0.01) 
			{
				
				for(float i=1; i<=16; i++)
				{
					float2 currentOffset 	= texcoord.xy + SceneNormals.xy * BUFFER_PIXEL_SIZE * i/(float)16 * 2048;
					float4 texelSample 	= tex2Dlod(ReShade::BackBuffer, float4(currentOffset,0,0));	
					
					float depthDiff 	= smootherstep(0.005,0.0,scenedepth-GetLinearDepth(currentOffset));
					float colorWeight 	= smootherstep(0.0,1.0+0.00001,dot(texelSample.xyz,float3(0.299,0.587,0.114)));
					bump += lerp(GIcolor.xyz,texelSample.xyz,depthDiff*colorWeight);
				}

				bump /= 16;

				float fReflect = clamp(fIBLIntensity*0.01,0.0,1.0);
				
				GIcolor = saturate(lerp(GIcolor.xyz, bump.xyz, fReflect));
				
			}
			
		float Grayscale = dot(GIcolor, Luma709);
		GIcolor = lerp(Grayscale, GIcolor, fGiSaturation);
		GIcolor = powsafe(GIcolor, fGiCompression);

		GIcolor = lerp(lerp(GIcolor, color,  GetLuma(color.rgb)), GIcolor, fGiPreserveHL);

		float edgesMask = saturate(lerp(1, 0, getEdges(ReShade::BackBuffer, vpos.xy, texcoord) * fGiEdgeMasking));

		if (iGiBlendMethod == 1) return lerp(color,lerp(color, float4(SoftLight(color, (GIcolor-color)+0.5),1.0), getGiMask(texcoord)),edgesMask);
		if (iGiBlendMethod == 2) return lerp(color,lerp(color, float4(Overlay(color, (GIcolor-color)+0.5),1.0), getGiMask(texcoord)),edgesMask);
		if (iGiBlendMethod == 3) return lerp(color,lerp(color, float4(BlendLightenf(color,GIcolor)), getGiMask(texcoord)),edgesMask);
		if (iGiBlendMethod == 4) return lerp(color,lerp(color, float4(BlendDarkenf(color,GIcolor)), getGiMask(texcoord)),edgesMask);
			else return lerp(color, lerp(color, GIcolor, getGiMask(texcoord)),edgesMask);
		
	}
}


// PS_LIGHTING /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 

void PS_LIGHTING(float4 vois : SV_Position, float2 TexCoord : TEXCOORD, out float3 color : SV_Target)
{
	// Grab background color
	color = tex2D(ReShade::BackBuffer, TexCoord).rgb;

	if (bENABLE_ENV && bUseLighting && (LDepth(TexCoord) <= GetCloseLightMask(TexCoord))) 
	{
		/// LIGHTING
		color.xyz = lerp(color, powsafe( color.xyz, fLightingGamma), GetCloseLightMask(TexCoord));
        float3 lightingColor = color.rgb;

		if (bUseShadow) 
		{
			if (fSTint != 0.0) lightingColor = (fSTint < 0.0) ? lerp( lightingColor, SoftLight( lightingColor, cold ), abs( (fSTint*0.1) * GetValueWeight(lightingColor).x )) :
				lerp( lightingColor, SoftLight( lightingColor, warm ), (fSTint*0.1) * GetValueWeight(lightingColor).x );
			lightingColor = fSContrast != 0 ? Softcontrast( lightingColor, fSContrast * GetValueWeight(lightingColor).x ) : lightingColor;
			lightingColor = fSBrightness != 0 ? SoftBrightness( lightingColor, fSBrightness * GetValueWeight(lightingColor).x ) : lightingColor;
			lightingColor = fSVibrance != 0 ? sat( lightingColor, fSVibrance * GetValueWeight(lightingColor).x ) : lightingColor;	
		}
		
		if (bUseAmbiant) 
		{
			if (fATint != 0.0) lightingColor = (fATint < 0.0) ? lerp( lightingColor, SoftLight( lightingColor, cold ), abs( (fATint*0.1) * GetValueWeight(lightingColor).y )) :
				lerp( lightingColor, SoftLight( lightingColor, warm ), (fATint*0.1) * GetValueWeight(lightingColor).y );
			lightingColor.xyz = fAContrast != 0 ? Softcontrast( lightingColor.xyz, fAContrast * GetValueWeight(lightingColor).y ) : lightingColor;
			lightingColor.xyz = fABrightness != 0 ? SoftBrightness( lightingColor.xyz, fABrightness * GetValueWeight(lightingColor).y): lightingColor;
			lightingColor.xyz = fASaturation != 0 ? sat( lightingColor.xyz, fASaturation * GetValueWeight(lightingColor).y ): lightingColor;
			
		}
		
		if (bUseHLight) 
		{
			if (fHLTint != 0.0) lightingColor = (fHLTint < 0.0) ? lerp( lightingColor, SoftLight( lightingColor, cold ), abs( (fHLTint*0.1) * GetValueWeight(lightingColor).z )) :
				lerp( lightingColor, SoftLight( lightingColor, warm ), (fHLTint*0.1) * GetValueWeight(lightingColor).z );
			lightingColor.xyz = fHLContrast != 0 ? Softcontrast( lightingColor.xyz, fHLContrast * GetValueWeight(lightingColor).z ): lightingColor;
			lightingColor.xyz = fHLExposure != 0 ? Softexposure( lightingColor.xyz, fHLExposure * GetValueWeight(lightingColor).z): lightingColor;
			lightingColor.xyz = fHLSaturation != 0 ? sat( lightingColor.xyz, fHLSaturation * GetValueWeight(lightingColor).z ): lightingColor;

		}
		
		color = (bUseShadow || bUseAmbiant || bUseHLight) ? lerp(color, lightingColor, GetCloseLightMask(TexCoord)) : color;
		
		// BLUE DROP
		if (fBlueSat.x != 0.0 || fBlueSat.y != 0.0) color = LUT_CL(color, LUTBLUESampler, lerp(0, fBlueSat, GetCloseLightMask(TexCoord)));
	
	}
	
	if (bENABLE_ENV && bUseLighting) 
	{
		if (fGammaDepth != 1.0)
		{
			color = bReverseGammaDepth ? lerp(color, powsafe(color,fGammaDepth), 1-LDepth(TexCoord)) : lerp(color, powsafe(color,fGammaDepth), LDepth(TexCoord));

		}
		if (fBlackPointDepth != 0.0 && !kInsert)
		{
			float3 blackColor = color * (255.0 / (255 - fBlackPointDepth)) - ((fBlackPointDepth / 255.0) *  (255.0 / (255 - fBlackPointDepth)));
			color = lerp(color, blackColor, LDepth(TexCoord));
		}
	}
	// DEBUG MASKS
	if (iShowLighting == 1) color *= 	GetCloseLightMask(TexCoord);
	if (iShowLighting == 2) color = 	lerp(0,GetValueWeight(color),GetCloseLightMask(TexCoord));
	if (iShowLighting == 3)	color = 	lerp(0,GetValueWeight(color),GetCloseLightMask(TexCoord));
	if (iShowLighting == 4)	color = 	lerp(0,GetValueWeight(color),GetCloseLightMask(TexCoord));
	
}

		/*//////////////////////////////////////////////////////////////////////////////////////////////////// 
		//											PS_LENS
		////////////////////////////////////////////////////////////////////////////////////////////////////*/
		
// PS_DOF //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 

void PS_Focus(float4 vpos : SV_Position, float2 texcoord : TEXCOORD, out float4 hdr1R : SV_Target0)
{
	float4 scenecolor = tex2D(ReShade::BackBuffer, texcoord);
	
	if (!bUseDOF || kHome) discard;
		else scenecolor.w = GetCoC(texcoord);

	hdr1R = scenecolor;
}

/* float SaveFocus(float4 pos : SV_Position, float2 texcoord : TEXCOORD) : SV_Target 
{
	return tex2D(SamplerHDR1, 0).x;
} */

void PS_MatsoDOF1(float4 vpos : SV_Position, float2 texcoord : TEXCOORD, out float4 hdr2R : SV_Target0)
{
	if (!bUseDOF || kHome) discard;
		hdr2R = GetMatsoDOFBlur(2, texcoord, SamplerHDR1);	
}
void PS_MatsoDOF2(float4 vpos : SV_Position, float2 texcoord : TEXCOORD, out float4 hdr1R : SV_Target0)
{
	if (!bUseDOF || kHome) discard;
		hdr1R = GetMatsoDOFBlur(3, texcoord, SamplerHDR2);	
}
void PS_MatsoDOF3(float4 vpos : SV_Position, float2 texcoord : TEXCOORD, out float4 hdr2R : SV_Target0)
{
	if (!bUseDOF || kHome) discard;
		hdr2R = GetMatsoDOFBlur(0, texcoord, SamplerHDR1);	
}

void PS_MatsoDOF4(float4 vpos : SV_Position, float2 texcoord : TEXCOORD, out float4 blurcolor : SV_Target)
{
	if (!bUseDOF || kHome) discard;
		float4 noblurcolor = tex2D(ReShade::BackBuffer, texcoord);
		blurcolor = GetMatsoDOFBlur(1, texcoord, SamplerHDR2);

		float centerDepth = GetCoC(texcoord);

		float blurAmount = abs(centerDepth * 2.0 - 1.0);
		float discRadius = blurAmount * DOF_BLURRADIUS;

		discRadius*=(centerDepth < 0.5) ? (1.0 / max(DOF_NEARBLURCURVE * 2.0, 1.0)) : 1.0; 
		blurcolor.xyz = lerp(noblurcolor.xyz,blurcolor.xyz,smootherstep(1.2,2.0,discRadius)); 
}


// PS_LENSHAZE /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 

void PS_LH_DetectInt(float4 vpos : SV_Position, float2 texcoord : TEXCOORD, out float4 detectInt : SV_Target0)
{
	detectInt = tex2D(ReShade::BackBuffer, texcoord);
}

void PS_LH_DetectLow(float4 vpos : SV_Position, float2 texcoord : TEXCOORD, out float4 detectLow : SV_Target0)
{
	detectLow = 0;

	if (USE_LensHaze && bENABLE_LENS) 
	{
		if (texcoord.x != 0.5 && texcoord.y != 0.5)
			discard;

		[loop]
		for (float i = 0.0; i <= 1; i += 0.03125)
		{
			[unroll]
			for (float j = 0.0; j <= 1; j += 0.03125)
			{
				detectLow.xyz += tex2D(LHS_HighColorDetect, float2(i, j)).xyz;
			}
		}

		detectLow.xyz /= 32 * 32;
	}
}

void PS_LH_DetectHigh(float4 vpos : SV_Position, float2 texcoord : TEXCOORD, out float4 x : SV_Target)
{
	x = tex2D(ReShade::BackBuffer, texcoord);
	if (USE_LensHaze && bENABLE_LENS) 
	{
		x = float4(x.rgb * pow(abs(max(x.r, max(x.g, x.b))), 2.0), 1.0f);

		float base = (x.r + x.g + x.b); base /= 3;

		float nR = (x.r * 2) - base;
		float nG = (x.g * 2) - base;
		float nB = (x.b * 2) - base;

		[flatten]
		if (nR < 0)
		{
			nG += nR / 2;
			nB += nR / 2;
			nR = 0;
		}
		[flatten]
		if (nG < 0)
		{
			nB += nG / 2;
			[flatten] if (nR > -nG / 2) nR += nG / 2; else nR = 0;
			nG = 0;
		}
		[flatten]
		if (nB < 0)
		{
			[flatten] if (nR > -nB / 2) nR += nB / 2; else nR = 0;
			[flatten] if (nG > -nB / 2) nG += nB / 2; else nG = 0;
			nB = 0;
		}

		[flatten]
		if (nR > 1)
		{
			nG += (nR - 1) / 2;
			nB += (nR - 1) / 2;
			nR = 1;
		}
		[flatten]
		if (nG > 1)
		{
			nB += (nG - 1) / 2;
			[flatten] if (nR + (nG - 1) < 1) nR += (nG - 1) / 2; else nR = 1;
			nG = 1;
		}
		[flatten]
		if (nB > 1)
		{
			[flatten] if (nR + (nB - 1) < 1) nR += (nB - 1) / 2; else nR = 1;
			[flatten] if (nG + (nB - 1) < 1) nG += (nB - 1) / 2; else nG = 1;
			nB = 1;
		}

		x.r = nR; x.g = nG; x.b = nB;
	}
}

void PS_LH_HGB(float4 vpos : SV_Position, float2 texcoord : TEXCOORD, out float4 hgb : SV_Target)
{
	if (!USE_LensHaze || !bENABLE_LENS) hgb = tex2D(ReShade::BackBuffer, texcoord);
	else 
	{
		const float sampleOffsets[5] = { 0.0, 2.4347826, 4.3478260, 6.2608695, 8.1739130 };
		const float sampleWeights[5] = { 0.16818994, 0.27276957, 0.111690125, 0.024067905, 0.0021112196 };

		hgb = tex2D(LHS_ColorIn, texcoord) * sampleWeights[0];
		hgb = float4(max(hgb.rgb - 64.0, 0.0), hgb.a);
		float stepMult = 1.08 + (LH_timer.x / 100) * 0.02;

		[flatten]
		if ((texcoord.x + sampleOffsets[1] * LHGI_PIXEL_SIZE.x) < 1.05)
			hgb += tex2D(LHS_ColorIn, texcoord + float2(sampleOffsets[1] * LHGI_PIXEL_SIZE.x, 0.0)) * sampleWeights[1] * stepMult;
		[flatten]
		if ((texcoord.x - sampleOffsets[1] * LHGI_PIXEL_SIZE.x) > -0.05)
			hgb += tex2D(LHS_ColorIn, texcoord - float2(sampleOffsets[1] * LHGI_PIXEL_SIZE.x, 0.0)) * sampleWeights[1] * stepMult;

		[flatten]
		if ((texcoord.x + sampleOffsets[2] * LHGI_PIXEL_SIZE.x) < 1.05)
			hgb += tex2D(LHS_ColorIn, texcoord + float2(sampleOffsets[2] * LHGI_PIXEL_SIZE.x, 0.0)) * sampleWeights[2] * stepMult;
		[flatten]
		if ((texcoord.x - sampleOffsets[2] * LHGI_PIXEL_SIZE.x) > -0.05)
			hgb += tex2D(LHS_ColorIn, texcoord - float2(sampleOffsets[2] * LHGI_PIXEL_SIZE.x, 0.0)) * sampleWeights[2] * stepMult;

		[flatten]
		if ((texcoord.x + sampleOffsets[3] * LHGI_PIXEL_SIZE.x) < 1.05)
			hgb += tex2D(LHS_ColorIn, texcoord + float2(sampleOffsets[3] * LHGI_PIXEL_SIZE.x, 0.0)) * sampleWeights[3] * stepMult;
		[flatten]
		if ((texcoord.x - sampleOffsets[3] * LHGI_PIXEL_SIZE.x) > -0.05)
			hgb += tex2D(LHS_ColorIn, texcoord - float2(sampleOffsets[3] * LHGI_PIXEL_SIZE.x, 0.0)) * sampleWeights[3] * stepMult;

		[flatten]
		if ((texcoord.x + sampleOffsets[4] * LHGI_PIXEL_SIZE.x) < 1.05)
			hgb += tex2D(LHS_ColorIn, texcoord + float2(sampleOffsets[4] * LHGI_PIXEL_SIZE.x, 0.0)) * sampleWeights[4] * stepMult;
		[flatten]
		if ((texcoord.x - sampleOffsets[4] * LHGI_PIXEL_SIZE.x) > -0.05)
			hgb += tex2D(LHS_ColorIn, texcoord - float2(sampleOffsets[4] * LHGI_PIXEL_SIZE.x, 0.0)) * sampleWeights[4] * stepMult;
	}
}

void PS_LH_VGB(float4 vpos : SV_Position, float2 texcoord : TEXCOORD, out float4 vgb : SV_Target)
{
	if (!USE_LensHaze || !bENABLE_LENS) vgb = tex2D(ReShade::BackBuffer, texcoord);
	else 
	{
		const float sampleOffsets[5] = { 0.0, 2.4347826, 4.3478260, 6.2608695, 8.1739130 };
		const float sampleWeights[5] = { 0.16818994, 0.27276957, 0.111690125, 0.024067905, 0.0021112196 };

		vgb = tex2D(LHS_ColorOut, texcoord) * sampleWeights[0];
		vgb = float4(max(vgb.rgb - 64.0, 0.0), vgb.a);
		float stepMult = 1.08 + (LH_timer.x / 100) * 0.02;

		[flatten]
		if ((texcoord.y + sampleOffsets[1] * LHGI_PIXEL_SIZE.y) < 1.05)
			vgb += tex2D(LHS_ColorOut, texcoord + float2(0.0, sampleOffsets[1] * LHGI_PIXEL_SIZE.y)) * sampleWeights[1] * stepMult;
		[flatten]
		if ((texcoord.y - sampleOffsets[1] * LHGI_PIXEL_SIZE.y) > -0.05)
			vgb += tex2D(LHS_ColorOut, texcoord - float2(0.0, sampleOffsets[1] * LHGI_PIXEL_SIZE.y)) * sampleWeights[1] * stepMult;

		[flatten]
		if ((texcoord.y + sampleOffsets[2] * LHGI_PIXEL_SIZE.y) < 1.05)
			vgb += tex2D(LHS_ColorOut, texcoord + float2(0.0, sampleOffsets[2] * LHGI_PIXEL_SIZE.y)) * sampleWeights[2] * stepMult;
		[flatten]
		if ((texcoord.y - sampleOffsets[2] * LHGI_PIXEL_SIZE.y) > -0.05)
			vgb += tex2D(LHS_ColorOut, texcoord - float2(0.0, sampleOffsets[2] * LHGI_PIXEL_SIZE.y)) * sampleWeights[2] * stepMult;

		[flatten]
		if ((texcoord.y + sampleOffsets[3] * LHGI_PIXEL_SIZE.y) < 1.05)
			vgb += tex2D(LHS_ColorOut, texcoord + float2(0.0, sampleOffsets[3] * LHGI_PIXEL_SIZE.y)) * sampleWeights[3] * stepMult;
		[flatten]
		if ((texcoord.y - sampleOffsets[3] * LHGI_PIXEL_SIZE.y) > -0.05)
			vgb += tex2D(LHS_ColorOut, texcoord - float2(0.0, sampleOffsets[3] * LHGI_PIXEL_SIZE.y)) * sampleWeights[3] * stepMult;

		[flatten]
		if ((texcoord.y + sampleOffsets[4] * LHGI_PIXEL_SIZE.y) < 1.05)
			vgb += tex2D(LHS_ColorOut, texcoord + float2(0.0, sampleOffsets[4] * LHGI_PIXEL_SIZE.y)) * sampleWeights[4] * stepMult;
		[flatten]
		if ((texcoord.y - sampleOffsets[4] * LHGI_PIXEL_SIZE.y) > -0.05)
			vgb += tex2D(LHS_ColorOut, texcoord - float2(0.0, sampleOffsets[4] * LHGI_PIXEL_SIZE.y)) * sampleWeights[4] * stepMult;
	}
}

float4 PS_LH_Mix(float4 vpos : SV_Position, float2 texcoord : TEXCOORD) : SV_Target
{
	float4 base = tex2D(ReShade::BackBuffer, texcoord);
	
	if (!USE_LensHaze || !bENABLE_LENS || iShowBloomMask > 0) return base;
	else 
	{
		float4 high = tex2D(LHS_ColorIn, texcoord);
		float adapt = 0;

		//DetectLow
		float4 detectLow = tex2D(LHS_LowColorDetect, 0.5) / 4.215;
		float low = sqrt(0.241 * detectLow.r * detectLow.r + 0.691 * detectLow.g * detectLow.g + 0.068 * detectLow.b * detectLow.b);
		//.DetectLow

		low = pow(low * 1.25f, 2);
		adapt = low * (low + 1.0f) * fLensHazeAdaptation * fLensHazeIntensity * 5.0f;

		

		high = min(0.0325f, high) * 1.15f;
		float4 highOrig = high;

		float2 flipcoord = 1.0f - texcoord;
		float4 highFlipOrig = tex2D(LHS_ColorIn, flipcoord);
		highFlipOrig = min(0.03f, highFlipOrig) * 1.15f;

		float4 highFlip = highFlipOrig;
		float4 highLensSrc = high;

		if (bUseLensDirt)
		{
			float4 dirt = tex2D(LHS_Dirt, texcoord);
			float4 dirtOVR = tex2D(LHS_DirtOVR, texcoord);
			float4 dirtOVB = tex2D(LHS_DirtOVB, texcoord);

			float maxhigh = max(high.r, max(high.g, high.b));
			float threshDiff = maxhigh - 3.2f;

			[flatten]
			if (threshDiff > 0)
			{
				high.r = (high.r / maxhigh) * 3.2f;
				high.g = (high.g / maxhigh) * 3.2f;
				high.b = (high.b / maxhigh) * 3.2f;
			}

			float4 highDirt = bUseVeryLensDirt ? highOrig * dirt * (fLensDirtIntensity*0.1) : highOrig * high * fLensDirtIntensity;

		
			highDirt *= 1.0f + 0.5f * sin(LH_timer.x);

			float highMix = highOrig.r + highOrig.g + highOrig.b;
			float red = highOrig.r / highMix;
			float green = highOrig.g / highMix;
			float blue = highOrig.b / highMix;
			highOrig = highOrig + highDirt;


			high = high + high * dirtOVR * alDirtOVInt * green;
			high = high + highDirt;
			high = high + highOrig * dirtOVB * alDirtOVInt * blue;
			high = high + highOrig * dirtOVR * alDirtOVInt* red;
			


			highLensSrc = high * 85f * pow(1.25f - (abs(texcoord.x - 0.5f) + abs(texcoord.y - 0.5f)), 2);
		}

		float origBright = max(highLensSrc.r, max(highLensSrc.g, highLensSrc.b));
		float maxOrig = max((1.8f * 0.5) - pow(origBright * (0.5f - abs(texcoord.x - 0.5f)), 4), 0.0f);
		float smartWeight = maxOrig * max(abs(flipcoord.x - 0.5f), 0.3f * abs(flipcoord.y - 0.5f)) * (2.2 - 1.2 * (abs(flipcoord.x - 0.5f))) * fLensDirtRefractionPower;
		smartWeight = min(0.85f, max(0, smartWeight - adapt));

			float4 lensDB = tex2D(LHS_DBLens, texcoord);
			float4 lensDB2 = tex2D(LHS_DB2Lens, texcoord);
			float4 lensDOV = tex2D(LHS_DOVLens, texcoord);
			float4 lensDUV = tex2D(LHS_DUVLens, texcoord);

			float4 highLens = highFlip * lensDB * 0.7f * smartWeight;
			high += highLens;

			highLens = highFlipOrig * lensDUV * 1.15f * smartWeight;
			highFlipOrig += highLens;
			high += highLens;

			highLens = highFlipOrig * lensDB2 * 0.7f * smartWeight;
			highFlipOrig += highLens;
			high += highLens;

			highLens = highFlipOrig * lensDOV * 1.15f * smartWeight / 2f + highFlipOrig * smartWeight / 2f;
			highFlipOrig += highLens;
			high += highLens;
		

		if (all(base.xyz == 1.0))
		{
			return 1.0;
		}


			base.xyz *= max(0.0f, (1.0f - adapt * 0.75f * fLensHazeCompression * pow(abs(1.0f - (base.x + base.y + base.z) / 3), lerp(0, 4, fLensHazeLightLevel*0.1))));
			float4 highSampleMix = (1.0 - ((1.0 - base) * (1.0 - high * 1.0)));
			float4 baseSample = lerp(base, highSampleMix, max(0.0f, fLensHazeIntensity - adapt));
			float baseSampleMix = baseSample.r + baseSample.g + baseSample.b;
			return baseSampleMix > 0.008 ? baseSample : lerp(base, highSampleMix, max(0.0f, (fLensHazeIntensity - adapt) * 0.85f) * baseSampleMix);
		}
}


// PS_BLOOM /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#define fBloomGamma clamp(0.5+fBloomContrast,1.0,2.2)
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 

void PS_DeBuGInputBloom(float4 vpos : SV_POSITION, float2 texcoord : TEXCOORD, out float4 output : SV_TARGET0)
{
	float4 color = tex2D(ReShade::BackBuffer, texcoord);
	if (iShowBloomMask == 1) 
	{
		color*= getBloomMask(texcoord);
		color = powsafe(color, fBloomGamma);
		
		float brightness = GetLuma(color.rgb);
		float knee = fBloomThreshold + 1e-5f;
		float3 curve = float3(fBloomThreshold - knee, knee * 2, 0.25f / knee);
		float rq = clamp(brightness - curve.x, 0, curve.y);
		rq = curve.z * rq * rq;
		
		output = color * (max(rq, brightness - fBloomThreshold) / max(brightness, 1e-5));
		output *= rcp(1-fBloomThreshold);

		float fBlack = fBloomContrast / 255.0;
		float fWhite = (255.0 / (lerp(255.0, 255.0, fBloomContrast) - fBloomContrast)); // 255.0-fBloomContrast

		output = output * fWhite - (fBlack *  fWhite);
		float ImageLuma = powsafe(brightness, fBloomThreshold);
		output += output * ImageLuma.xxx * fBloomPushHL;
		output = powsafe(output, fBloomContrast);
	}
	
	else output = color;
}

void PS_InputBloom(float4 vpos : SV_POSITION, float2 texcoord : TEXCOORD, out float4 output : SV_TARGET0)
{
	float4 color = tex2D(ReShade::BackBuffer, texcoord);
	
	if (USE_LensBloom && bENABLE_LENS && iShowBloomMask !=1)
	{
		color*= getBloomMask(texcoord);
		color = powsafe(color, fBloomGamma);
		
		float brightness = GetLuma(color.rgb);
		float knee = fBloomThreshold + 1e-5f;
		float3 curve = float3(fBloomThreshold - knee, knee * 2, 0.25f / knee);
		float rq = clamp(brightness - curve.x, 0, curve.y);
		rq = curve.z * rq * rq;
		
		output = color * (max(rq, brightness - fBloomThreshold) / max(brightness, 1e-5));
		output *= rcp(1-fBloomThreshold);

		float fBlack = fBloomContrast / 255.0;
		float fWhite = (255.0 / (lerp(255.0, 255.0, fBloomContrast) - fBloomContrast)); // 255.0-fBloomContrast

		output = output * fWhite - (fBlack *  fWhite);
		float ImageLuma = powsafe(brightness, fBloomThreshold);
		output += output * ImageLuma.xxx * fBloomPushHL;
		output = powsafe(output, fBloomContrast);
	}
	
	else output = color;
}

void HorizontalForwardFilter(uint3 id, int filterWidth, float k)
{
	if (USE_LensBloom && bENABLE_LENS) 
	{
		float2 coord = float2(id.x * PIXELS_PER_THREAD, id.y) + 0.5;
		float4 curr[3];
		float4 prev[3];
		
		float denominator = k * k + 3 * k + 3;
		float3 currWeights = float3(3, 6, 3) / denominator;
		float2 prevWeights = float2(-6 + 2*k*k, -k*k + 3 * k - 3) / denominator;
		prev[0] = UnpackColors(tex2Dfetch(sBlur1, clamp(float2(coord.x - filterWidth, coord.y), 0, float2(BUFFER_WIDTH, BUFFER_HEIGHT) - 1))).xyzx;
		float brightness = max(max(prev[0].r, prev[0].g), prev[0].b);
		prev[1] = prev[0].yyyy;
		prev[2] = prev[0].zzzz;
		prev[0] = prev[0].xxxx;
		curr[0] = prev[0];
		curr[1] = prev[1];
		curr[2] = prev[2];

		for(int i = -filterWidth + 1; i < PIXELS_PER_THREAD; i++)
		{
			float2 sampleCoord = clamp(float2(coord.x + i, coord.y), 0, float2(BUFFER_WIDTH, BUFFER_HEIGHT) - 1);
			float3 newSample = UnpackColors(tex2Dfetch(sBlur1, sampleCoord));
			[unroll]
			for(int j = 0; j < 3; j++)
			{
				curr[j] = float4(newSample[j], curr[j].xyz);
				prev[j] = float4(dot(curr[j].xyz, currWeights) + dot(prev[j].xy, prevWeights), prev[j].xyz);
			}
			if(i >= 0)
			{
				tex2Dstore(wBlur0, int2(coord.x + i, coord.y), PackColors(float3(prev[0].x, prev[1].x, prev[2].x)));
			}
		}
	}
}

void HorizontalBackwardFilter(uint3 id, int filterWidth, float k)
{
	if (USE_LensBloom && bENABLE_LENS) 
	{
		float2 coord = float2(id.x * PIXELS_PER_THREAD + PIXELS_PER_THREAD, id.y) + 0.5;
		float4 curr[3];
		float4 prev[3];
		float denominator = k * k + 3 * k + 3;
		float3 currWeights = float3(3, 6, 3) / denominator;
		float2 prevWeights = float2(-6 + 2*k*k, -k*k + 3 * k - 3) / denominator;
		prev[0] = UnpackColors(tex2Dfetch(sBlur0, clamp(float2(coord.x + filterWidth, coord.y), 0, float2(BUFFER_WIDTH, BUFFER_HEIGHT) - 1))).xyzx;
		prev[1] = prev[0].yyyy;
		prev[2] = prev[0].zzzz;
		prev[0] = prev[0].xxxx;
		curr[0] = prev[0];
		curr[1] = prev[1];
		curr[2] = prev[2];


		for(int i = filterWidth - 1; i > -PIXELS_PER_THREAD; i--)
		{
			float2 sampleCoord = clamp(float2(coord.x + i, coord.y), 0, float2(BUFFER_WIDTH, BUFFER_HEIGHT) - 1);
			float3 newSample = UnpackColors(tex2Dfetch(sBlur0, sampleCoord));
			[unroll]
			for(int j = 0; j < 3; j++)
			{
				curr[j] = float4(newSample[j], curr[j].xyz);
				prev[j] = float4(dot(curr[j].xyz, currWeights) + dot(prev[j].xy, prevWeights), prev[j].xyz);
			}
			if(i <= 0)
			{
				//float storedSample = (prev + tex2Dfetch(sBlur0, int2(coord.x + i, coord.y)).x) * 0.5;
				barrier();
				tex2Dstore(wBlur1, int2(coord.x + i, coord.y), PackColors(float3(prev[0].x, prev[1].x, prev[2].x)));
			}
		}
	}
}

void VerticalForwardFilter(uint3 id, int filterWidth, float k)
{
	if (USE_LensBloom && bENABLE_LENS) 
	{
		float2 coord = float2(id.x, id.y * PIXELS_PER_THREAD) + 0.5;
		float4 curr[3];
		float4 prev[3];
		float denominator = k * k + 3 * k + 3;
		float3 currWeights = float3(3, 6, 3) / denominator;
		float2 prevWeights = float2(-6 + 2*k*k, -k*k + 3 * k - 3) / denominator;
		
		prev[0] = UnpackColors(tex2Dfetch(sBlur1, clamp(float2(coord.x, coord.y - filterWidth), 0, float2(BUFFER_WIDTH, BUFFER_HEIGHT) - 1))).xyzx;
		prev[1] = prev[0].yyyy;
		prev[2] = prev[0].zzzz;
		prev[0] = prev[0].xxxx;
		curr[0] = prev[0];
		curr[1] = prev[1];
		curr[2] = prev[2];

		for(int i = -filterWidth + 1; i < PIXELS_PER_THREAD; i++)
		{
			float2 sampleCoord = clamp(float2(coord.x, coord.y + i), 0, float2(BUFFER_WIDTH, BUFFER_HEIGHT) - 1);
			float3 newSample = UnpackColors(tex2Dfetch(sBlur1, sampleCoord));
			[unroll]
			for(int j = 0; j < 3; j++)
			{
				curr[j] = float4(newSample[j], curr[j].xyz);
				prev[j] = float4(dot(curr[j].xyz, currWeights) + dot(prev[j].xy, prevWeights), prev[j].xyz);
			}
			if(i >= 0)
			{
				tex2Dstore(wBlur0, int2(coord.x, coord.y + i), PackColors(float3(prev[0].x, prev[1].x, prev[2].x)));
			}
		}
	}
}

void VerticalBackwardFilter(uint3 id, int filterWidth, float k)
{
	if (USE_LensBloom && bENABLE_LENS) 
	{
		float2 coord = float2(id.x, id.y * PIXELS_PER_THREAD + PIXELS_PER_THREAD) + 0.5;
		float4 curr[3];
		float4 prev[3];
		float denominator = k * k + 3 * k + 3;
		float3 currWeights = float3(3, 6, 3) / denominator;
		float2 prevWeights = float2(-6 + 2*k*k, -k*k + 3 * k - 3) / denominator;

		prev[0] = UnpackColors(tex2Dfetch(sBlur0, clamp(float2(coord.x, coord.y + filterWidth), 0, float2(BUFFER_WIDTH, BUFFER_HEIGHT) - 1))).xyzx;
		prev[1] = prev[0].yyyy;
		prev[2] = prev[0].zzzz;
		prev[0] = prev[0].xxxx;
		curr[0] = prev[0];
		curr[1] = prev[1];
		curr[2] = prev[2];


		for(int i = filterWidth - 1; i > -PIXELS_PER_THREAD; i--)
		{
			float2 sampleCoord = clamp(float2(coord.x, coord.y + i), 0, float2(BUFFER_WIDTH, BUFFER_HEIGHT) - 1);
			float3 newSample = UnpackColors(tex2Dfetch(sBlur0, sampleCoord));
			[unroll]
			for(int j = 0; j < 3; j++)
			{
				curr[j] = float4(newSample[j], curr[j].xyz);
				prev[j] = float4(dot(curr[j].xyz, currWeights) + dot(prev[j].xy, prevWeights), prev[j].xyz);
			}
			if(i <= 0)
			{
				tex2Dstore(wBlur1, int2(coord.x, coord.y + i), PackColors(float3(prev[0].x, prev[1].x, prev[2].x)));
			}
		}
	}	
}

void HorizontalFilterCS0(uint3 id : SV_DispatchThreadID)
{
	if (USE_LensBloom && bENABLE_LENS) HorizontalForwardFilter(id, FILTER_WIDTH, fLensBloomRadius);
}

void HorizontalFilterCS1(uint3 id : SV_DispatchThreadID)
{
	if (USE_LensBloom && bENABLE_LENS) HorizontalBackwardFilter(id, FILTER_WIDTH, fLensBloomRadius);
}

void VerticalFilterCS0(uint3 id : SV_DispatchThreadID)
{
	if (USE_LensBloom && bENABLE_LENS) VerticalForwardFilter(id, FILTER_WIDTH, fLensBloomRadius);
}

void VerticalFilterCS1(uint3 id : SV_DispatchThreadID)
{
	if (USE_LensBloom && bENABLE_LENS) VerticalBackwardFilter(id, FILTER_WIDTH, fLensBloomRadius);
}


// PS_RATIO ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 

float3 PS_AspectRatio(float4 pos : SV_Position, float2 texcoord : TEXCOORD) : SV_Target
{
	bool Mask = false;
	
	// Center coordinates
	float2 coord = texcoord-0.5;
	
	if (!bUseLensDistortion || !bENABLE_LENS) return tex2D(ReShade::BackBuffer, texcoord);
	else 
	{

		// Squeeze horizontally
		if (fLensProps<0)
		{
			coord.x *= abs(fLensProps)+1.0; // Apply distortion

			// Scale to borders
			if (FitScreen) coord /= abs(fLensProps)+1.0;
			else // Mask image borders
				Mask = abs(coord.x)>0.5;
		}
		// Squeeze vertically
		else if (fLensProps>0)
		{
			coord.y *= fLensProps+1.0; // Apply distortion

			// Scale to borders
			if (FitScreen) coord /= abs(fLensProps)+1.0;
			else // Mask image borders
				Mask = abs(coord.y)>0.5;
		}

		// Coordinates back to the corner
		coord += 0.5;

		// Sample display image and return
		if (!FitScreen) // If borders are visible
			return Mask? BlackColor.rgb : tex2D(ReShade::BackBuffer, coord).rgb;
		else
			return Mask? BlackColor.rgb : tex2D(ReShade::BackBuffer, coord).rgb;
	}
}	


// PS_LENS_SHAKE ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
uniform float2 fRandomVert < source = "pingpong"; min = 1; max = 3; step = 0.5; smoothing = 0.0; >;
uniform float2 fRandomHori < source = "pingpong"; min = 0; max = 2; step = 1; smoothing = 0.0; >;
uniform float2 fRandomIntensity < source = "pingpong"; min = 1; max = 10; step = 0.3; smoothing = 0.0; >;
#define shake_duration 	fShakeDuration.x
#define shake_often 	fShakeDuration.y
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 

void PS_LensShake(float4 position : SV_Position, float2 tex : TEXCOORD, out float4 col : SV_Target) 
{
	bool isInMotion;
	
	if (iKBD == 0) isInMotion = kStrafeLeftUS || kStrafeRight || kStrafeForwardUS || kStrafeBack;
	if (iKBD == 1) isInMotion = kStrafeLeft || kStrafeRight || kStrafeForward || kStrafeBack;
	if (DEVBUILD) isInMotion = RightMouseDown || kStrafeLeft || kStrafeRight || kStrafeBack;

	if (!isInMotion || !USE_LensShake || kDel) col = tex2D(ReShade::BackBuffer, tex);
	else
	{
		float shake_size;
		if (DEVBUILD) shake_size = lerp(fShakeAmplitude.x*0.01, fShakeAmplitude.x*0.02, RightMouseDown || kStrafeForward || kStrafeForwardUS || kStrafeBack);
			else shake_size = lerp(fShakeAmplitude.x*0.01, fShakeAmplitude.x*0.02, kStrafeForward || kStrafeForwardUS || kStrafeBack);
		
		float trans_size = lerp(fShakeAmplitude.y*0.5, fShakeAmplitude.y*2.0, kStrafeLeft || kStrafeLeftUS || kStrafeRight); 
	
		float fShake_Vert;
		if (bUseRandom) fShake_Vert =shake_size*(fRandomIntensity*0.1);
			else fShake_Vert = shake_size;
		
		float shake_freq=fShakeFrequency.x;
		float trans_freq=fShakeFrequency.y;
		
		if (bUseRandom) shake_freq*=fRandomVert;
		if (bUseRandom) trans_freq*=fRandomHori;
		
		float2 uv = tex / f2Resolution;
		uv *= (1.0 - 2.0 * max(fShake_Vert, trans_size * fShake_Vert));

		float t = clamp(mod(ftimer2, shake_often), 0.0, shake_duration) / shake_duration;
		
		float shake_magnitude = fShake_Vert * sin(shake_freq * 2.0*3.14159*t) * (t+0.5)*t*t*(t-1.0)*(t-1.0)*15.5;
		float2 shake_direction = normalize(float2(0.0, 1.0));
		uv += shake_direction * shake_magnitude;
		
		float2 shake_transverse = float2(-shake_direction.y, shake_direction.x);
		float trans_magnitude = trans_size * fShake_Vert * sin(trans_freq * 2.*3.14159*t) * -t*(t-1.);
		uv += trans_magnitude * shake_transverse;

		col = tex2D(ReShade::BackBuffer, tex+uv);

	}

}


// PS_LENS_DISTORTION //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 

float3 PS_FISHEYE_CA(float4 position : SV_Position, float2 texcoord : TexCoord) : SV_Target
{
	float3 color = tex2D(ReShade::BackBuffer, texcoord).rgb;
	float fFisheyeDistortionModifier;
	float fFisheyeDistortionCubicModifier;
	
	if (bUseLensDistortion && bENABLE_LENS) 
	{
		if (bLensDistPerfectFit) 
		{
			fFisheyeDistortionModifier = saturate(lerp(0.0,0.135f,fFisheyeDistortion));
			fFisheyeDistortionCubicModifier = saturate(lerp(0.0,0.075f,fFisheyeDistortionEdges));
		}
		else 
		{
			fFisheyeDistortionModifier = saturate(lerp(0.0,0.115f,fFisheyeDistortion));
			fFisheyeDistortionCubicModifier = saturate(lerp(0.0,0.055f,fFisheyeDistortionEdges));
		}

		
		float4 coord=0.0;
		coord.xy=texcoord.xy;
		coord.w=0.0;

		color.rgb = 0.0;
		  
		float3 eta = float3(1.0+(fFisheyeCA*0.1)*0.9,1.0+(fFisheyeCA*0.1)*0.6,1.0+(fFisheyeCA*0.1)*0.3);
		float2 center;
		center.x = coord.x-0.5;
		center.y = coord.y-0.5;
		float LensZoom = 1.0/(0.5f + fFisheyeDistortionModifier + fFisheyeDistortionCubicModifier);

		float r2 = (texcoord.y-0.5) * (texcoord.y-0.5);// + (texcoord.y-0.5) * (texcoord.y-0.5);
		float f = 0;

		if( fFisheyeDistortionEdges == 0.0){
			f = 1 + r2 * fFisheyeDistortion;
		}else{
					f = 1 + r2 * (fFisheyeDistortion + fFisheyeDistortionEdges * sqrt(r2));
		};

		float x = f*LensZoom*(coord.x-0.5)+0.5;
		float y = f*LensZoom*(coord.y-0.5)+0.5;
		
		float2 rCoords = (f*eta.r)*LensZoom*(center.xy*0.5)+0.5;
		float2 gCoords = (f*eta.g)*LensZoom*(center.xy*0.5)+0.5;
		float2 bCoords = (f*eta.b)*LensZoom*(center.xy*0.5)+0.5;
		
		color.x = tex2D(ReShade::BackBuffer,rCoords).r;
		color.y = tex2D(ReShade::BackBuffer,gCoords).g;
		color.z = tex2D(ReShade::BackBuffer,bCoords).b;
	}
	
	return color.rgb;
}	


// PS_GAUSSIAN_BLUR ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 
 
float3 PS_GaussianBlur_Lens1(in float4 pos : SV_Position, in float2 texcoord : TEXCOORD) : COLOR
{  
	float3 color = tex2D(ReShade::BackBuffer, texcoord).rgb;
	
	if (bUseLensBlur && LensBlur_Offset > 0.0 && bENABLE_LENS) 
	{
		float B_depth = linearDepth(LDepth(texcoord), 0.5f, skyDistance*0.5);
		float D_PrePassOffset = LensBlur_Offset+fLensSharpness*0.1;
		
		// REGULAR BLUR
		if(LensBlur_Offset < 1.0)	
		{
			float offset[4] = { 0.0, 1.1824255238, 3.0293122308, 5.0040701377 };
			float weight[4] = { 0.39894, 0.2959599993, 0.0045656525, 0.00000149278686458842 };
			
			color *= weight[0];
			
			[loop]
			for(int i = 1; i < 4; ++i)
			{
				color += tex2D(ReShade::BackBuffer, texcoord + float2(offset[i] * BUFFER_PIXEL_SIZE.x, 0.0) * lerp(LensBlur_Offset,D_PrePassOffset,B_depth)).rgb * weight[i];
				color += tex2D(ReShade::BackBuffer, texcoord - float2(offset[i] * BUFFER_PIXEL_SIZE.x, 0.0) * lerp(LensBlur_Offset,D_PrePassOffset,B_depth)).rgb * weight[i];
			}
		}	

		if(LensBlur_Offset >= 1.0)	
		{
			float offset[6] = { 0.0, 1.4584295168, 3.40398480678, 5.3518057801, 7.302940716, 9.2581597095 };
			float weight[6] = { 0.13298, 0.23227575, 0.1353261595, 0.0511557427, 0.01253922, 0.0019913644 };
			
			color *= weight[0];
			
			[loop]
			for(int i = 1; i < 6; ++i)
			{
				color += tex2D(ReShade::BackBuffer, texcoord + float2(offset[i] * BUFFER_PIXEL_SIZE.x, 0.0) * lerp(LensBlur_Offset-1.0,D_PrePassOffset-1.0,B_depth)).rgb * weight[i];
				color += tex2D(ReShade::BackBuffer, texcoord - float2(offset[i] * BUFFER_PIXEL_SIZE.x, 0.0) * lerp(LensBlur_Offset-1.0,D_PrePassOffset-1.0,B_depth)).rgb * weight[i];
			}
		}

	}
	
	return saturate(color);
}

/// DIRT VERSION
float3 PS_GaussianBlur_LensDirt1(in float4 pos : SV_Position, in float2 texcoord : TEXCOORD) : COLOR
{  
	float3 color = tex2D(ReShade::BackBuffer, texcoord).rgb;
	float3 Dirtcolor = color;	
	float fDirtMultiplier=0;

	if ((fBloomDirtIntensity > 0.0 || bUseLensDirt || bUseVeryLensDirt || fLensDirtIntensity > 0.0) && bENABLE_LENS && bLinkToBloomDirt)
	{
		float3 DirtImage = tex2D(LHS_DirtM, texcoord).rgb;
		float DirtMask = GetLuma(DirtImage);
		
		if (fLensDirtIntensity > 0.0 || fBloomDirtIntensity > 0.0)
		fDirtMultiplier = saturate(fLensDirtIntensity+fBloomDirtIntensity);
	
		float3 blurDirt = lerp(0.0, 2.0, DirtMask*fDirtMultiplier);
		float3 Dblur = lerp(LensBlur_Offset, blurDirt, fDirtMultiplier);
		
		float LBoffset[6] = { 0.0, 1.4584295168, 3.40398480678, 5.3518057801, 7.302940716, 9.2581597095 };
		float LBweight[6] = { 0.13298, 0.23227575, 0.1353261595, 0.0511557427, 0.01253922, 0.0019913644 };
		
		Dirtcolor *= LBweight[0];
		
		[loop]
		for(int i = 1; i < 6; ++i)
		{
			Dirtcolor += tex2D(ReShade::BackBuffer, texcoord + float2(LBoffset[i] * BUFFER_PIXEL_SIZE.x, 0.0) * Dblur).rgb * LBweight[i];
			Dirtcolor += tex2D(ReShade::BackBuffer, texcoord - float2(LBoffset[i] * BUFFER_PIXEL_SIZE.x, 0.0) * Dblur).rgb * LBweight[i];
		}
		
	} 
		
	color = lerp(color, Dirtcolor, fDirtMultiplier);
	return saturate(color);
}

float3 PS_GaussianBlur_LensFinal(in float4 pos : SV_Position, in float2 texcoord : TEXCOORD) : COLOR
{
	float3 color = tex2D(ReShade::BackBuffer, texcoord).rgb;

	if (bUseLensBlur && LensBlur_Offset > 0.0 && bENABLE_LENS) 
	{	
		float B_depth = linearDepth(LDepth(texcoord), 0.5f, skyDistance*0.5);
		float D_PrePassOffset = LensBlur_Offset+fLensSharpness*0.1;
		
		if(LensBlur_Offset < 1.0)
		{
			float offset[4] = { 0.0, 1.1824255238, 3.0293122308, 5.0040701377 };
			float weight[4] = { 0.39894, 0.2959599993, 0.0045656525, 0.00000149278686458842 };
			
			color *= weight[0];
			
			[loop]
			for(int i = 1; i < 4; ++i)
			{
				color += tex2D(GaussianBlur_Sampler, texcoord + float2(0.0, offset[i] * BUFFER_PIXEL_SIZE.y) * lerp(LensBlur_Offset,D_PrePassOffset,B_depth)).rgb * weight[i];
				color += tex2D(GaussianBlur_Sampler, texcoord - float2(0.0, offset[i] * BUFFER_PIXEL_SIZE.y) * lerp(LensBlur_Offset,D_PrePassOffset,B_depth)).rgb * weight[i];
			}
		}	

		if(LensBlur_Offset >= 1.0)
		{
			float offset[6] = { 0.0, 1.4584295168, 3.40398480678, 5.3518057801, 7.302940716, 9.2581597095 };
			float weight[6] = { 0.13298, 0.23227575, 0.1353261595, 0.0511557427, 0.01253922, 0.0019913644 };
			
			color *= weight[0];
			
			[loop]
			for(int i = 1; i < 6; ++i)
			{
				color += tex2D(GaussianBlur_Sampler, texcoord + float2(0.0, offset[i] * BUFFER_PIXEL_SIZE.y) * lerp(LensBlur_Offset-1.0,D_PrePassOffset-1.0,B_depth)).rgb * weight[i];
				color += tex2D(GaussianBlur_Sampler, texcoord - float2(0.0, offset[i] * BUFFER_PIXEL_SIZE.y) * lerp(LensBlur_Offset-1.0,D_PrePassOffset-1.0,B_depth)).rgb * weight[i];
			}
		}	
	}

	return saturate(color);
}

/// DIRT VERSION
float3 PS_GaussianBlur_LensDirtFinal(in float4 pos : SV_Position, in float2 texcoord : TEXCOORD) : COLOR
{
	float3 color = tex2D(ReShade::BackBuffer, texcoord).rgb;
	float3 Dirtcolor = color;	
	float fDirtMultiplier=0;
	
		
	if ((fBloomDirtIntensity > 0.0 || bUseLensDirt || bUseVeryLensDirt || fLensDirtIntensity > 0.0) && bENABLE_LENS && bLinkToBloomDirt)
	{
		float3 DirtImage = tex2D(LHS_DirtM, texcoord).rgb;
		float DirtMask = GetLuma(DirtImage);
		
		if (fLensDirtIntensity > 0.0 || fBloomDirtIntensity > 0.0)
		fDirtMultiplier = saturate(fLensDirtIntensity+fBloomDirtIntensity);
	
		float3 blurDirt = lerp(0.0, 2.0, DirtMask*fDirtMultiplier);
		float3 Dblur = lerp(LensBlur_Offset, blurDirt, fDirtMultiplier);
		
		float LBoffset[6] = { 0.0, 1.4584295168, 3.40398480678, 5.3518057801, 7.302940716, 9.2581597095 };
		float LBweight[6] = { 0.13298, 0.23227575, 0.1353261595, 0.0511557427, 0.01253922, 0.0019913644 };
		
		Dirtcolor *= LBweight[0];
		
		[loop]
		for(int i = 1; i < 6; ++i)
		{
			Dirtcolor += tex2D(GaussianDirtBlur_Sampler, texcoord + float2(LBoffset[i] * BUFFER_PIXEL_SIZE.y, 0.0) * Dblur).rgb * LBweight[i];
			Dirtcolor += tex2D(GaussianDirtBlur_Sampler, texcoord - float2(LBoffset[i] * BUFFER_PIXEL_SIZE.y, 0.0) * Dblur).rgb * LBweight[i];
		}
		
	} 
		
	color = lerp(color, Dirtcolor, fDirtMultiplier);
	return saturate(color);
}


// PS_LENS_SHARP ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 

float3 PS_LumaSharpenPrePass(float4 position : SV_Position, float2 tex : TEXCOORD) : SV_Target
{

	float3 ori = tex2D(ReShade::BackBuffer, tex).rgb;
	
	if (!bUseLensBlur || !bENABLE_LENS) return ori;
	else 
	{
		float fLensDofSharpMulti = 1.0;

		float3 sharp_strength_luma = (Luma709 * lerp(fLensSharpness, 0.0f,linearDepth(LDepth(tex), 0.5f, fSharpDistance))); 
	
		float3 blur_ori;

		blur_ori  = tex2D(ReShade::BackBuffer, tex + BUFFER_PIXEL_SIZE * float2(0.4, -1.2) * lerp((fLensSharpnessRadius.y*ResModifier()), (fLensSharpnessRadius.x*ResModifier())*0.333, linearDepth(LDepth(tex), 0.5f, fSharpDistance))).rgb;  // South South East
		blur_ori += tex2D(ReShade::BackBuffer, tex - BUFFER_PIXEL_SIZE * float2(1.2, 0.4) * lerp((fLensSharpnessRadius.y*ResModifier()), (fLensSharpnessRadius.x*ResModifier())*0.333, linearDepth(LDepth(tex), 0.5f, fSharpDistance))).rgb; // West South West
		blur_ori += tex2D(ReShade::BackBuffer, tex + BUFFER_PIXEL_SIZE * float2(1.2, 0.4) * lerp((fLensSharpnessRadius.y*ResModifier()), (fLensSharpnessRadius.x*ResModifier())*0.333, linearDepth(LDepth(tex), 0.5f, fSharpDistance))).rgb; // East North East
		blur_ori += tex2D(ReShade::BackBuffer, tex - BUFFER_PIXEL_SIZE * float2(0.4, -1.2) * lerp((fLensSharpnessRadius.y*ResModifier()), (fLensSharpnessRadius.x*ResModifier())*0.333, linearDepth(LDepth(tex), 0.5f, fSharpDistance))).rgb; // North North West

		blur_ori *= 0.25;  
		sharp_strength_luma *= 0.51;
		
		float3 sharp = ori - blur_ori; 

		float4 sharp_strength_luma_clamp = float4(sharp_strength_luma * (0.5 / 0.05),0.5);

		float sharp_luma = saturate(dot(float4(sharp,1.0), sharp_strength_luma_clamp)); 
		sharp_luma = (0.05 * 2.0) * sharp_luma - 0.05; 

		float3 outputcolor = ori + sharp_luma;    

		if (show_sharpen)
		{
			outputcolor = saturate(0.5 + (sharp_luma * 4.0)).rrr;
		}

		return saturate(outputcolor);
	}
}

		/*//////////////////////////////////////////////////////////////////////////////////////////////////// 
		//											PS_CAMERA
		////////////////////////////////////////////////////////////////////////////////////////////////////*/
		
// PS_TONEMAP //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 

float4 GetSmallPS(float4 p : SV_POSITION, float2 uv : TEXCOORD) : SV_TARGET
{
	
	if (!bENABLE_CAMERA || fCamIntensity == 0) return 0.0;
	else
	{
		float adapt = dot(tex2D(BackBuffer_Linear, uv).rgb, LumaWeights);
		adapt *= fAdaptCurve;

		float last = tex2Dfetch(LastAdapt, 0).x;
		float AT = AdaptTime;
		if (AdaptTime > 0.0)
			
			if (AdaptMetering < 1) AT -= 0.2;
			if (AdaptMetering > 1) AT += 0.2;
			adapt = lerp(last, adapt, saturate((FrameTime * 0.001) / AT));

		return adapt;
	}
}

float4 SaveAdaptPS(float4 p : SV_POSITION, float2 uv : TEXCOORD) : SV_TARGET
{
	if (!bENABLE_CAMERA || fCamIntensity == 0) return 0.0;
	else return get_adapt();
}

float4 PS_Tonemapper(float4 p : SV_POSITION,float2 uv : TEXCOORD0,float inv_white : TEXCOORD1,float exposure : TEXCOORD2) : SV_TARGET
{
	float4 color = tex2D(BackBuffer_Point, uv);

	if (bENABLE_CAMERA && fCamIntensity == 1) color.rgb = lerp(color.rgb,tonemap(color.rgb, exposure) * inv_white, 0.25); //VeryLow
	if (bENABLE_CAMERA && fCamIntensity == 2) color.rgb = lerp(color.rgb,tonemap(color.rgb, exposure) * inv_white, 0.33); //Low
	if (bENABLE_CAMERA && fCamIntensity == 3) color.rgb = lerp(color.rgb,tonemap(color.rgb, exposure) * inv_white, 0.50); //Med
	if (bENABLE_CAMERA && fCamIntensity == 4) color.rgb = lerp(color.rgb,tonemap(color.rgb, exposure) * inv_white, 0.64); //High
	if (bENABLE_CAMERA && fCamIntensity == 5) color.rgb = lerp(color.rgb,tonemap(color.rgb, exposure) * inv_white, 0.75); //VeryHigh
	if (bENABLE_CAMERA && fCamIntensity == 6) color.rgb = lerp(color.rgb,tonemap(color.rgb, exposure) * inv_white, 1.0); //Full	
	
	return color;
	
}

void PS_AGX(float4 vpos : SV_Position, float2 TexCoord : TEXCOORD, out float3 Image : SV_Target)

{
	Image = tex2D(ReShade::BackBuffer, TexCoord).rgb;
	float3 AGXcolor = Image;
	
	if (bAGX && bENABLE_CAMERA) 
	{
		AGXcolor = AGX_AIO(AGXcolor);
		if (iAGXBlend == 0) Image = AGXcolor;
		if (iAGXBlend == 1) Image = BlendLightenf(Image,AGXcolor);
		if (iAGXBlend == 2) Image = BlendDarkenf(Image,AGXcolor);
		if (iAGXBlend == 3) Image = SoftLight(Image,(AGXcolor-Image)+0.5f);
		if (iAGXBlend == 4) Image = BlendColor(Image,AGXcolor);
		if (iAGXBlend == 5) Image = BlendLuminosity(Image,AGXcolor);
	}

}


// PS_WHITE_BALANCE ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 

float4 PS_WriteColor(float4 pos : SV_Position, float2 texcoord : TEXCOORD) : SV_Target
{
   return tex2D( ReShade::BackBuffer, texcoord );
}

void PS_MinMax_1( float4 pos : SV_Position, float2 texcoord : TEXCOORD, out float4 minValue : SV_Target0, out float4 maxValue : SV_Target1, out float4 midValue : SV_Target2 )
{
	if (AutoWhiteBalance && bENABLE_CAMERA) 
	{
		float3 currColor;
		float3 minMethod0  = 1.0f;
		float3 minMethod1  = 1.0f;
		float3 maxMethod0  = 0.0f;
		float3 maxMethod1  = 0.0f;
		midValue           = 0.0f;

		float getMid;   float getMid2;
		float getMin;   float getMin2;
		float getMax;   float getMax2;

		float3 prevMin     = tex2D( samplerPrevious, float2( texcoord.x / 6.0f, texcoord.y )).xyz;
		float3 prevMax     = tex2D( samplerPrevious, float2(( texcoord.x + 4.0f ) / 6.0f, texcoord.y )).xyz;
		float middle       = dot( float2( dot( prevMin.xyz, 0.333333f ), dot( prevMax.xyz, 0.333333f )), 0.5f );
		middle             = ( bMidpointAverage ) ? middle : 0.5f;

		// RenderTarget size is 32x32
		float pst          = 0.03125f;    // rcp( 32 )
		float hst          = 0.5f * pst;  // half size

		// Sample texture
		float2 stexSize    = float2( BUFFER_WIDTH/1, BUFFER_HEIGHT/1 );
		uint OFFSET        = 1 + 1 * 3;
		float2 start       = floor(( texcoord.xy - hst ) * stexSize.xy );    // sample block start position
		float2 stop        = floor(( texcoord.xy + hst ) * stexSize.xy );    // ... end position

		[loop]
		for( int y = start.y; y < stop.y && y < stexSize.y; y += OFFSET )
		{
			for( int x = start.x; x < stop.x && x < stexSize.x; x += OFFSET )
			{
				currColor      = tex2Dfetch( samplerColor, int2( x, y ), 0 ).xyz;
				// Dark color detection methods
				// Per channel
				minMethod0.xyz = min( minMethod0.xyz, currColor.xyz );
				// By color
				getMin         = max( max( currColor.x, currColor.y ), currColor.z ) + dot( currColor.xyz, 1.0f );
				getMin2        = max( max( minMethod1.x, minMethod1.y ), minMethod1.z ) + dot( minMethod1.xyz, 1.0f );
				minMethod1.xyz = ( getMin2 >= getMin ) ? currColor.xyz : minMethod1.xyz;
				// Mid point detection
				getMid         = dot( abs( currColor.xyz - middle ), 1.0f );
				getMid2        = dot( abs( midValue.xyz - middle ), 1.0f );
				midValue.xyz   = ( getMid2 >= getMid ) ? currColor.xyz : midValue.xyz;
				
				// Light color detection methods
				// Per channel
				maxMethod0.xyz = max( currColor.xyz, maxMethod0.xyz );
				// By color
				getMax         = dot( currColor.xyz, 1.0f );
				getMax2        = dot( maxMethod1.xyz, 1.0f );
				maxMethod1.xyz = ( getMax >= getMax2 ) ? currColor.xyz : maxMethod1.xyz;
			}
		}

		minValue.xyz       = blackpoint_method ? minMethod1.xyz : minMethod0.xyz;
		maxValue.xyz       = whitepoint_method ? maxMethod1.xyz : maxMethod0.xyz;
		// Return
		minValue           = float4( minValue.xyz, 1.0f );
		maxValue           = float4( maxValue.xyz, 1.0f );
		midValue           = float4( midValue.xyz, 1.0f );
    }
}

float4 PS_MinMax_1x1( float4 pos : SV_Position, float2 texcoord : TEXCOORD ) : SV_Target
{
	if (!AutoWhiteBalance || !bENABLE_CAMERA) return 0.0;
	else
	{
		float3 minColor; float3 maxColor; float3 midColor;
		float3 minValue; float3 maxValue; float3 midValue;
		float getMin;    float getMin2;
		float getMax;    float getMax2;
		float3 minMethod0  = 1.0f;
		float3 minMethod1  = 1.0f;
		float3 maxMethod0  = 0.0f;
		float3 maxMethod1  = 0.0f;
		midValue           = 0.0f;
		//Get texture resolution
		int2 SampleRes     = 32;
		float Sigma        = 0.0f;

		for( int y = 0; y < SampleRes.y; ++y )
		{
			for( int x = 0; x < SampleRes.x; ++x )
			{   
				// Dark color detection methods
				minColor       = tex2Dfetch( samplerDS_1_Min, int2( x, y ), 0 ).xyz;
				// Per channel
				minMethod0.xyz = min( minMethod0.xyz, minColor.xyz );
				// By color
				getMin         = max( max( minColor.x, minColor.y ), minColor.z ) + dot( minColor.xyz, 1.0f );
				getMin2        = max( max( minMethod1.x, minMethod1.y ), minMethod1.z ) + dot( minMethod1.xyz, 1.0f );
				minMethod1.xyz = ( getMin2 >= getMin ) ? minColor.xyz : minMethod1.xyz;
				// Mid point detection
				midColor       += tex2Dfetch( samplerDS_1_Mid, int2( x, y ), 0 ).xyz;
				Sigma          += 1.0f;
				// Light color detection methods
				maxColor       = tex2Dfetch( samplerDS_1_Max, int2( x, y ), 0 ).xyz;
				// Per channel
				maxMethod0.xyz = max( maxColor.xyz, maxMethod0.xyz );
				// By color
				getMax         = dot( maxColor.xyz, 1.0f );
				getMax2        = dot( maxMethod1.xyz, 1.0f );
				maxMethod1.xyz = ( getMax >= getMax2 ) ? maxColor.xyz : maxMethod1.xyz;
			}
		}

		minValue.xyz       = blackpoint_method ? minMethod1.xyz : minMethod0.xyz;
		maxValue.xyz       = whitepoint_method ? maxMethod1.xyz : maxMethod0.xyz;
		midValue.xyz       = midColor.xyz / Sigma;

		maxValue.xyz       = ( minValue.xyz >= maxValue.xyz ) ? float3( 1.0f, 1.0f, 1.0f ) : maxValue.xyz;

		float3 prevMin     = tex2D( samplerPrevious, float2( texcoord.x / 6.0f, texcoord.y )).xyz;
		float3 prevMid     = tex2D( samplerPrevious, float2(( texcoord.x + 2.0f ) / 6.0f, texcoord.y )).xyz;
		float3 prevMax     = tex2D( samplerPrevious, float2(( texcoord.x + 4.0f ) / 6.0f, texcoord.y )).xyz;

		float time         = FrameTime * 0.001f;
		maxValue.xyz       = lerp( prevMax.xyz, maxValue.xyz, saturate((FrameTime * 0.001) / AdaptTimeColor));
		minValue.xyz       = lerp( prevMin.xyz, minValue.xyz, saturate((FrameTime * 0.001) / AdaptTimeColor));
		midValue.xyz       = lerp( prevMid.xyz, midValue.xyz, saturate((FrameTime * 0.001) / AdaptTimeColor)); 
		
		
		// Return
		if( pos.x < 2 )
			return float4( minValue.xyz, 1.0f );
		else if( pos.x >= 2 && pos.x < 4 )
			return float4( midValue.xyz, 1.0f );
		else
			return float4( maxValue.xyz, 1.0f );
		return float4( 0.5, 0.5, 0.5, 1.0 );
	}
}

float4 PS_RemoveTint(float4 pos : SV_Position, float2 texcoord : TEXCOORD) : SV_Target
{
	float4 color       = tex2D( samplerColor, texcoord );
	
	if (AutoWhiteBalance && bENABLE_CAMERA) 
	{
		// Grab min, max, mid values
		float3 minValue    = tex2D( samplerDS_1x1, float2( texcoord.x / 6.0f, texcoord.y )).xyz;
		float3 midValue    = tex2D( samplerDS_1x1, float2(( texcoord.x + 2.0f ) / 6.0f, texcoord.y )).xyz;
		float3 maxValue    = tex2D( samplerDS_1x1, float2(( texcoord.x + 4.0f ) / 6.0f, texcoord.y )).xyz;
		// Get middle correction method
		float middle       = dot( float2( dot( minValue.xyz, 0.333333f ), dot( maxValue.xyz, 0.333333f )), 0.5f );
		middle             = bMidpointAverage ? middle : 0.5f;
		// Set min value
		minValue.xyz       = lerp( 0.0f, minValue.xyz, 1.0 );
		minValue.xyz       = minValue.xyz;
		// Set max value
		maxValue.xyz       = lerp( 1.0f, maxValue.xyz, fWhitePointCorrectionIntensity );
		maxValue.xyz       = maxValue.xyz;
		// Set mid value
		midValue.xyz       = midValue.xyz - middle;
		midValue.xyz       *= fAutoBalanceIntensity;
		midValue.xyz       = midValue.xyz;
		// Main color correction
		color.xyz          = saturate( color.xyz - minValue.xyz ) / ( maxValue.xyz - minValue.xyz );
		// White Point luma preservation
		float avgMax       = dot( maxValue.xyz, 0.333333f );
		color.xyz          = lerp( color.xyz, color.xyz * avgMax, 1.0 );
		// Black Point luma preservation
		float avgMin       = dot( minValue.xyz, 0.333333f );
		//color.xyz          = lerp( color.xyz, color.xyz * ( 1.0f - avgMin ) + avgMin, rt_bp_rl_str );
		// Mid Point correction
		float avgCol       = dot( color.xyz, 0.333333f ); // Avg after main correction
		float avgMid       = dot( midValue.xyz, 0.333333f );
		avgCol             = 1.0f - abs( avgCol * 2.0f - 1.0f );
		color.xyz          = saturate( color.xyz - midValue.xyz * avgCol + avgMid * avgCol * bMidpointRespectGamma );

	}

	if (bENABLE_CAMERA && Kelvin != 6500) 
	{
		// Color Temperature
		float3 kColor    = KelvinToRGB( Kelvin );
		float3 oLum      = RGBToHSL( color.xyz );
		float3 blended   = color.xyz * kColor.xyz;
		float3 resHSV    = RGBToHSL( blended.xyz );
		float3 resRGB    = HSLToRGB( float3( resHSV.xy, oLum.z ));
		color.xyz        = LumPreservation ? resRGB.xyz : blended.xyz;
	}

   return float4( color.xyz, 1.0f );
}

float4 PS_StorePrev( float4 pos : SV_Position, float2 texcoord : TEXCOORD ) : SV_Target
{
	if (!AutoWhiteBalance || !bENABLE_CAMERA ) return 0.0;
	else
	{
		float3 minValue    = tex2D( samplerDS_1x1, float2( texcoord.x / 6.0f, texcoord.y )).xyz;
		float3 midValue    = tex2D( samplerDS_1x1, float2(( texcoord.x + 2.0f ) / 6.0f, texcoord.y )).xyz;
		float3 maxValue    = tex2D( samplerDS_1x1, float2(( texcoord.x + 4.0f ) / 6.0f, texcoord.y )).xyz;
		if( pos.x < 2 )
			return float4( minValue.xyz, 1.0f );
		else if( pos.x >= 2 && pos.x < 4 )
			return float4( midValue.xyz, 1.0f );
		else
			return float4( maxValue.xyz, 1.0f );
	}
}

		/*//////////////////////////////////////////////////////////////////////////////////////////////////// 
		//											PS_POSTPROCESSING
		////////////////////////////////////////////////////////////////////////////////////////////////////*/
		
// PS_LUT //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 
 
void CCLUT(float4 vois : SV_Position, float2 TexCoord : TEXCOORD, out float3 Image : SV_Target)
{
	Image = tex2D(ReShade::BackBuffer, TexCoord).rgb;

	if (bENABLE_CC) 
	{
		if (iLUTSet == 1) Image = LUT_CL(Image, LUTCCSampler, LutChromaLuma);
		if (iLUTSet == 2) Image = LUT_CL(Image, LUTCCSampler2, LutChromaLuma);
		if (kInsert) 	  Image = LUT_CL(Image, LUTNightSampler, float2(1.0,0.5));
		else Image = LUT_CL(Image, LUTNightSampler, float2(fPurkinjeFX,fPurkinjeFX));
		if (bUseOutput) Image.rgb = powsafe(Image,fGamma);
	}
}




// PS_LENS_SHADOW ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 

float4 PS_Vignette(float4 vpos : SV_Position, float2 tex : TexCoord) : SV_Target
{
	float4 color = tex2D(ReShade::BackBuffer, tex);
	if (bUseLenShadow && bENABLE_LENS) {
		// Set the center
		float2 distance_xy = tex - perfectCenter;

		// Adjust the ratio
		distance_xy *= float2((BUFFER_RCP_HEIGHT / BUFFER_RCP_WIDTH), fLensShadowShape);

		// Calculate the distance
		distance_xy /= fLensShadowSoftness;
		float distance = dot(distance_xy, distance_xy);

		// Apply the vignette
		color.rgb *= (1.0 + pow(distance, iLensShadowDistance * 0.5) * fLensShadowResult); //pow - multiply

	}
	return color;
}


// PS_DEBAND ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 

float3 PS_Deband(float4 vpos : SV_Position, float2 texcoord : TexCoord) : SV_Target
{
    float3 ori = tex2Dlod(ReShade::BackBuffer, float4(texcoord, 0.0, 0.0)).rgb;

    if (fDebandPower == 0.0 || LDepth(texcoord) < DebandDistancecMin) return ori;
	else 
	{
		// Initialize the PRNG by hashing the position + a random uniform
		float3 m = float3(texcoord + 1.0, (drandom / 32767.0) + 1.0);
		float h = permute(permute(permute(m.x) + m.y) + m.z);

		// Compute a random angle
		float dir  = random(permute(h)) * 6.2831853;
		float2 o;
		sincos(dir, o.y, o.x);
		
		// Distance calculations
		float2 pt;
		float dist;

		//Debanding steps per pixel
		for (int i = 1; i <= 3; ++i) {
			dist = random(h) * fDetectionRadius * i;
			pt = dist * BUFFER_PIXEL_SIZE;
		
			h = permute(h);
		}
		
		// Sample at quarter-turn intervals around the source pixel
		float3 ref[4] = {
			tex2Dlod(ReShade::BackBuffer, float4(mad(pt,                  o, texcoord), 0.0, 0.0)).rgb, // SE
			tex2Dlod(ReShade::BackBuffer, float4(mad(pt,                 -o, texcoord), 0.0, 0.0)).rgb, // NW
			tex2Dlod(ReShade::BackBuffer, float4(mad(pt, float2(-o.y,  o.x), texcoord), 0.0, 0.0)).rgb, // NE
			tex2Dlod(ReShade::BackBuffer, float4(mad(pt, float2( o.y, -o.x), texcoord), 0.0, 0.0)).rgb  // SW
		};

		// Calculate weber ratio
		float3 mean = (ori + ref[0] + ref[1] + ref[2] + ref[3]) * 0.2;
		float3 k = abs(ori - mean);
		for (int j = 0; j < 4; ++j) {
			k += abs(ref[j] - mean);
		}

		k = k * 0.2 / mean;

		// Calculate std. deviation
		float3 sd = 0.0;

		for (int j = 0; j < 4; ++j) {
			sd += pow(ref[j] - ori, 2);
		}

		sd = sqrt(sd * 0.25);

		// Generate final output
		float3 output;

		output = (ref[0] + ref[1] + ref[2] + ref[3]) * 0.25;

		// Generate a binary banding map
		bool3 banding_map = true;

		banding_map = banding_map && k <= fDebandPower*0.02;
		banding_map = banding_map && sd <= fDebandPower*0.01;

	 return banding_map ? output : ori;

   }
}


// PS_PIXELSHARP ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 

float3 PS_LumaSharpenPassDetails(float4 position : SV_Position, float2 tex : TEXCOORD) : SV_Target
{
	// -- Get the original pixel --
	float3 ori = tex2D(ReShade::BackBuffer, tex).rgb; // ori = original pixel
	
	if (fPixelSharpIntensity < 0.1 || !bENABLE_CC) return ori;
	else 
	{
		float fDofPixSharpMulti = 1.0;

		float3 sharp_strength_luma = ((Luma709 * fPixelSharpIntensity) * fDofPixSharpMulti); //I'll be combining even more multipliers with it later on

		float3 blur_ori;

			blur_ori  = tex2D(ReShade::BackBuffer, tex + float2(0.5 * BUFFER_PIXEL_SIZE.x, -BUFFER_PIXEL_SIZE.y * offset_bias)).rgb;  // South South East
			blur_ori += tex2D(ReShade::BackBuffer, tex + float2(offset_bias * -BUFFER_PIXEL_SIZE.x, 0.5 * -BUFFER_PIXEL_SIZE.y)).rgb; // West South West
			blur_ori += tex2D(ReShade::BackBuffer, tex + float2(offset_bias * BUFFER_PIXEL_SIZE.x, 0.5 * BUFFER_PIXEL_SIZE.y)).rgb; // East North East
			blur_ori += tex2D(ReShade::BackBuffer, tex + float2(0.5 * -BUFFER_PIXEL_SIZE.x, BUFFER_PIXEL_SIZE.y * offset_bias)).rgb; // North North West

			blur_ori /= 4.0; 

			sharp_strength_luma *= 0.666; 

		float3 sharp = ori - blur_ori;  

		float4 sharp_strength_luma_clamp = float4(sharp_strength_luma * (0.5 / 1.0),0.5); 

		float sharp_luma = saturate(dot(float4(sharp,1.0), sharp_strength_luma_clamp)); 
		sharp_luma = (1.0 * 2.0) * sharp_luma - 1.0; 

		float3 outputcolor = ori + sharp_luma;

		

		return saturate(outputcolor);
	}
}


// PS_SOFTNESS /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 

static const float KERNEL[KERNEL_RADIUS + 1] = {0.002436706343803515, 0.004636114237302254, 0.008296608238596322, 0.013965003570314828, 0.022109289813789203, 
												0.032923196406968135, 0.0461130337346424, 0.06074930837220863, 0.07527587082752966, 0.08773365683170255,
												0.09617695873269712, 0.09916850578089087};
												


uint ArrayIndex(const uint2 accessCoord, const uint2 arrayDimensions)
{
	return (arrayDimensions.x * accessCoord.y) + accessCoord.x;
}

//functions for packing/unpacking a float3 into a single uint (10 bits of precision)
uint Float3ToUint(float3 fValue)
{
	fValue = saturate(fValue);
	uint uValue = 0;
	uValue = uint(fValue[0] * 1023);
	uValue = uint(fValue[1] * 1023) | (uValue << 10);
	uValue = uint(fValue[2] * 1023) | (uValue << 10);
	return uValue;
}

float3 UintToFloat3(uint uValue)
{
	float3 fValue;
	fValue[0] = float(uValue >> 20) / 1023;
	fValue[1] = float((uValue & 0x000FFC00) >> 10) / 1023;
	fValue[2] = float((uValue & 0x000003FF)) / 1023;
	return fValue;
}

groupshared uint samples[ARRAY_DIMENSIONS.x*ARRAY_DIMENSIONS.y];

void KernelIteration(uint iteration, float3 currentSamples[SAMPLES_PER_THREAD], inout float3 kernelOutput[SAMPLES_PER_THREAD])
{
	[unroll]
	for(int i = 0; i < SAMPLES_PER_THREAD; i++)
	{
		kernelOutput[i] += KERNEL[iteration] * currentSamples[i];
	}
}

void UpdateCurrentSamples(int2 indexCoords, inout float3 currentSamples[SAMPLES_PER_THREAD])
{
	[unroll]
	for(int i = 0; i < SAMPLES_PER_THREAD - 1; i++)
	{
		currentSamples[i] = currentSamples[i + 1];
	}
	currentSamples[SAMPLES_PER_THREAD - 1] = UintToFloat3(samples[ArrayIndex(indexCoords, ARRAY_DIMENSIONS)]);
}

void HorizontalPassCS(uint3 gid : SV_GroupID, uint3 gtid : SV_GroupThreadID)
{
	if (bENABLE_CC) 
	{
		float3 kernelOutput[SAMPLES_PER_THREAD];
		float3 currentSamples[SAMPLES_PER_THREAD];
		int2 indexCoords;
		indexCoords.x = (gtid.x * SAMPLES_PER_THREAD);
		indexCoords.y = gtid.y;
		int2 sampleOffset = indexCoords;
		sampleOffset.x -= KERNEL_RADIUS - SAMPLES_PER_THREAD;
		int2 groupCoord = int2(gid.x * SAMPLES_PER_THREAD * GROUP_WIDTH, gid.y * GROUP_HEIGHT);
		
		[unroll]
		for(int i = 0; i < SAMPLES_PER_THREAD; i++)
		{
			uint arrayIndex = ArrayIndex(int2(indexCoords.x + i, indexCoords.y), ARRAY_DIMENSIONS);
			int2 sampleCoord = sampleOffset + groupCoord;
			sampleCoord.x += i;
			sampleCoord = clamp(sampleCoord, 0, float2(BUFFER_WIDTH, BUFFER_HEIGHT));
			currentSamples[i] = tex2Dfetch(ReShade::BackBuffer, sampleCoord).rgb;
			samples[arrayIndex] = Float3ToUint(currentSamples[i]);
		}
		
		indexCoords.x = SAMPLES_PER_THREAD * GROUP_WIDTH + gtid.x;
		
		
		//The extra samples needed for padding the kernel
		[unroll]
		while(indexCoords.x < ARRAY_DIMENSIONS.x)
		{
			sampleOffset.x = indexCoords.x - KERNEL_RADIUS + SAMPLES_PER_THREAD;
			int2 sampleCoord = sampleOffset + groupCoord;
			sampleCoord = clamp(sampleCoord, 0, float2(BUFFER_WIDTH, BUFFER_HEIGHT));
			uint arrayIndex = ArrayIndex(indexCoords, ARRAY_DIMENSIONS);
			samples[arrayIndex] = Float3ToUint(tex2Dfetch(ReShade::BackBuffer, sampleCoord).rgb);
			indexCoords.x += GROUP_WIDTH;
		}
		
		barrier();
		

		indexCoords.x = (gtid.x * SAMPLES_PER_THREAD);
		
		//left side and center of the kernel
		[unroll]
		for(int i = 0; i <= KERNEL_RADIUS; i++)
		{
			KernelIteration(i, currentSamples, kernelOutput);
			UpdateCurrentSamples(indexCoords, currentSamples);
			indexCoords.x++;
		}
		
		//right side of the kernel
		[unroll]
		for(int i = KERNEL_RADIUS - 1; i >= 0; i--)
		{
			KernelIteration(i, currentSamples, kernelOutput);
			UpdateCurrentSamples(indexCoords, currentSamples);
			indexCoords.x++;
		}
		indexCoords.x = (gtid.x * SAMPLES_PER_THREAD);
		int2 coord = indexCoords + groupCoord;
		//coord.x -= SAMPLES_PER_THREAD;
		//store the horizontal to a placeholder texture
		[unroll]
		for(int i = 0; i < SAMPLES_PER_THREAD; i++)
		{
			tex2Dstore(wPlaceHolder, coord, float4(kernelOutput[i], 1));
			coord.x++;
		}
	}
}

void VerticalPassCS(uint3 gid : SV_GroupID, uint3 gtid : SV_GroupThreadID)
{
	if (bENABLE_CC) 
	{
		float3 kernelOutput[SAMPLES_PER_THREAD];
		float3 currentSamples[SAMPLES_PER_THREAD];
		int2 indexCoords;
		indexCoords.x = (gtid.x * SAMPLES_PER_THREAD);
		indexCoords.y = gtid.y;
		int2 sampleOffset = indexCoords;
		sampleOffset.x -= KERNEL_RADIUS - SAMPLES_PER_THREAD;
		int2 groupCoord = int2(gid.x * SAMPLES_PER_THREAD * GROUP_WIDTH, gid.y * GROUP_HEIGHT);
		
		//load the samples into shared memory
		[unroll]
		for(int i = 0; i < SAMPLES_PER_THREAD; i++)
		{
			uint arrayIndex = ArrayIndex(int2(indexCoords.x + i, indexCoords.y), ARRAY_DIMENSIONS);
			int2 sampleCoord = sampleOffset + groupCoord;
			sampleCoord.x += i;
			sampleCoord = clamp(sampleCoord, 0, float2(BUFFER_HEIGHT, BUFFER_WIDTH));
			currentSamples[i] = tex2Dfetch(sPlaceHolder, sampleCoord.yx).rgb;
			samples[arrayIndex] = Float3ToUint(currentSamples[i]);
		}
		
		indexCoords.x = SAMPLES_PER_THREAD * GROUP_WIDTH + gtid.x;
		
		
		//The extra samples needed for padding the kernel
		[unroll]
		while(indexCoords.x < ARRAY_DIMENSIONS.x)
		{
			sampleOffset.x = indexCoords.x - KERNEL_RADIUS + SAMPLES_PER_THREAD;
			int2 sampleCoord = sampleOffset + groupCoord;
			sampleCoord = clamp(sampleCoord, 0, float2(BUFFER_HEIGHT, BUFFER_WIDTH));
			uint arrayIndex = ArrayIndex(indexCoords, ARRAY_DIMENSIONS);
			samples[arrayIndex] = Float3ToUint(tex2Dfetch(sPlaceHolder, sampleCoord.yx).rgb);
			indexCoords.x += GROUP_WIDTH;
		}
		
		barrier();
		

		indexCoords.x = (gtid.x * SAMPLES_PER_THREAD);
		
		//Top side and center of the kernel
		[unroll]
		for(int i = 0; i <= KERNEL_RADIUS; i++)
		{
			KernelIteration(i, currentSamples, kernelOutput);
			UpdateCurrentSamples(indexCoords, currentSamples);
			indexCoords.x++;
		}
		
		//Bottom side of the kernel
		[unroll]
		for(int i = KERNEL_RADIUS - 1; i >= 0; i--)
		{
			KernelIteration(i, currentSamples, kernelOutput);
			UpdateCurrentSamples(indexCoords, currentSamples);
			indexCoords.x++;
		}
		
		indexCoords.x = (gtid.x * SAMPLES_PER_THREAD);
		int2 coord = indexCoords + groupCoord;
		//coord.x -= SAMPLES_PER_THREAD;
		[unroll]
		for(int i = 0; i < SAMPLES_PER_THREAD; i++)
		{
			tex2Dstore(wConvolution, coord.yx, float4(kernelOutput[i], 1));
			coord.x++;
		}
	}
}

void SoftnessPS(float4 pos : SV_Position, float2 texcoord : TEXCOORD, out float4 color : SV_Target0)
{
	if (bENABLE_CC) 
	{
		color = SoftLight(tex2D(ReShade::BackBuffer, texcoord), (tex2D(sConvolution, texcoord) - tex2D(ReShade::BackBuffer, texcoord)) + 0.5f);

		if(fSoftness < 0.0) color = lerp(tex2D(ReShade::BackBuffer, texcoord), color, fSoftness);
		else color = lerp(tex2D(ReShade::BackBuffer, texcoord), color, lerp(fSoftness, fSoftness*1.33, GetLinearDepth(texcoord)+0.1));
	}
	else color = tex2D(ReShade::BackBuffer, texcoord);

}


// PS_OUTPUT ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 

void PSBloomMixOutput(float4 vpos : SV_POSITION, float2 texcoord : TEXCOORD, out float4 output : SV_TARGET0)
{
	float4 color = tex2D(ReShade::BackBuffer, texcoord);

	if (USE_LensBloom && bENABLE_LENS) 
	{
		float3 bloom = UnpackColors(tex2D(sBlur1, texcoord));
		float grey = dot(bloom, 0.33333);
		bloom = lerp(grey, bloom, fBloomSaturation);

		float fLBIM = iBloomBlendMethod == 0 ? 2.0 : 1.0;
		fLBIM+=fBloomDirtIntensity;
		
		bloom *= bBloomWdepth ? lerp(0.0, fLensBloomIntensity*fLBIM, getBloomMask(texcoord)) : fLensBloomIntensity*fLBIM;
		if (iShowBloomMask == 2)bloom = fBloomPreserveHL > 0.0 ? lerp(bloom , lerp(bloom, 0.0,  GetLuma(color.rgb)),fBloomPreserveHL) : bloom;
		
		if (fBloomDirtIntensity > 0.0)
		{
			float3 DirtImage = tex2D(LHS_DirtM, texcoord).rgb;
			float DirtMask = GetLuma(DirtImage);
			float3 bloomDirt = lerp(0.0,bloom,DirtMask*fBloomDirtIntensity);
			bloom = lerp(bloom,bloomDirt,fBloomDirtIntensity);
		}

		if(iBloomBlendMethod == 0) output = powsafe(powsafe(color, fBloomGamma) + bloom * (1-fBloomThreshold), rcp(fBloomGamma));
		if(iBloomBlendMethod == 1) output = BlendAddf(color, bloom);
		if(iBloomBlendMethod == 2) output = BlendScreenf(color, bloom);
		if(iBloomBlendMethod == 3) output = BlendLightenf(color, bloom );
		if(iBloomBlendMethod == 4) output = SoftLight(color, bloom+0.5);
		
		output = fBloomPreserveHL > 0.0 ? lerp(output, lerp(output, color,  GetLuma(color.rgb)), fBloomPreserveHL) : output;

		if(iShowBloomMask == 2) output = powsafe(bloom * (1-fBloomThreshold), rcp(fBloomGamma));
	}
	
	else output = color;
	
	if (bENABLE_CC && bUseOutput) 
	{
		// Shadow Desaturation
		if (fDesaturateShadows != 0.0)
		{
			float4	tempvar;
			tempvar.x=saturate(1.0-getAvgColor(output.rgb));
			tempvar.x*=tempvar.x;
			tempvar.x*=tempvar.x;
			output=lerp(output,getAvgColor(output.rgb), fDesaturateShadows*tempvar.x);
		}

		//Levels
		if (fPSBP != 0 || fPSWP != 255) 
		{
			float fBlack = fPSBP / 255.0;
			float fWhite = (255.0 / (fPSWP - fPSBP));
			output = output * fWhite - (fBlack *  fWhite);
			output = saturate(output);
		}

		//Contrast
		if (fCtrstOut != 0) 
		{
			float luma = GetLuma(output.rgb);
			float3 chroma = output.rgb - luma;
			float3 contrast = luma;
		
			if (iCtrstMethod == 0) contrast = (contrast-fCtrstPoint) * (fCtrstOut*0.1+1) + fCtrstPoint;
			if (iCtrstMethod == 1) contrast = saturate(LUT(powsafe(contrast,fCtrstPoint), CtrstDownLUTSampler, (fCtrstOut-(fCtrstOut*2.0))*0.1 ));

			if (iCtrstMethod == 2)  //curve
			{
				contrast = contrast - 0.5;
				contrast = (contrast / (0.5 + abs(contrast))) + 0.5;
				contrast = lerp(luma, powsafe(contrast,fCtrstPoint), fCtrstOut * 0.2);
			}
			
			output.rgb = contrast + chroma;
		}

		// Saturation Limit 
		if (saturation_limit != 1.0)
		{
			output.xyz = RGBToHSL( output.xyz );
			output.y = min( output.y, saturation_limit );
			output.xyz = HSLToRGB( output.xyz );
		}
		
		if (fLBox != 0.0) output = BorderPass(output, texcoord);

	}
	
	output = (iShowGiMask == 3) ? saturate(lerp(1, 0, getEdges(ReShade::BackBuffer, vpos.xy, texcoord) * fGiEdgeMasking)) : output;
	if (bValueCheck) output=dot(output.xyz, 0.3333);
	
	float3 dither = 0; float amount = 0;
	if (iDitherMethod !=0) 
	{
		float luma=GetLuma(output);
		amount=lerp(Linear1(1.0/STEPS),Linear1((1.0/STEPS)+1.0)-1.0,luma);
		
		if (iDitherMethod == 1) dither = TriDither(output.rgb, texcoord, BUFFER_COLOR_BIT_DEPTH); 
		if (iDitherMethod == 2) dither = ScreenSpaceDitherTri(vpos.xy);
		if (iDitherMethod == 3) dither = interleaved_gradient(vpos.xy);
		if (iDitherMethod == 3) dither.y = ign3(vpos.xy + 0.5);
	}

	output = (iDitherMethod > 0) ? output+dither*amount : output;
	
}

/// CAMERA STAMPS
float2 scale_uv(float2 uv, float2 scale, float2 center) {
	return (uv - center) * scale + center;
}

float4 PS_Logo(float4 pos : SV_POSITION, float2 uv : TEXCOORD) : SV_TARGET 
{
	float2 ar = f2Resolution.x > f2Resolution.y ? float2(f2Resolution.x / f2Resolution.y, 1.0) : float2(1.0, f2Resolution.y / f2Resolution.x);
	float2 corrected = ReShade::ScreenSize;
	
	float2 stretch = lerp(ReShade::ScreenSize * f2PixelSize / ar, corrected * ReShade::PixelSize, 1.0);

	float2 uv_Logo;

	uv_Logo = scale_uv(uv,stretch,float2(perfectCenter.x, 1.0 - perfectCenter.y));

	float4 original = tex2D(ReShade::BackBuffer, uv);
	float4 Logo;

	if (kInsert) 
	{
		float4 LogoNightSet = tex2D(sNightSet, uv_Logo);
		original += lerp(0.0f, LogoNightSet, LogoNightSet.a);
	}
	
	return original;
}

		/*////////////////////////////////////////////////////////////////////////////////////////////////////
		//////////////////////////////////////////////////////////////////////////////////////////////////////
		
		//											TECHNIQUES 
		
		//////////////////////////////////////////////////////////////////////////////////////////////////////
		////////////////////////////////////////////////////////////////////////////////////////////////////*/
technique CLEANLIGHT
{
	//////////////////////////////////////////////////////////////////////////////////////////////////////////
	// ENVIRONMENTS //////////////////////////////////////////////////////////////////////////////////////////
	// SKYLIGHT
	pass SkyEnv 			{VertexShader = PostProcessVS;	PixelShader = PS_Environment;}
	
	// SMOOTH NORMALS
	pass GetNormals 		{VertexShader  = PostProcessVS;	PixelShader = GBuffer1;	RenderTarget0 = SSSR_NormTex;}
	pass SmoothNormalHpass 	{VertexShader = PostProcessVS;	PixelShader = SNH;		RenderTarget = SSSR_NormTex;}
	pass SmoothNormalVpass 	{VertexShader = PostProcessVS;	PixelShader = SNV;		RenderTarget = SSSR_NormTex;}
	
	// GLOBAL ILLUMINATION
	pass GI_DetectIntRad 	{VertexShader = PostProcessVS;PixelShader = PS_GI_DetectInt;RenderTarget = GidetectIntTex;}
	pass GI_DetectLowRad	{VertexShader = PostProcessVS;PixelShader = PS_GI_DetectLow;RenderTarget = GidetectLowTex;}
	pass GI_DetectHighRad	{VertexShader = PostProcessVS;PixelShader = PS_GI_DetectHigh;RenderTarget = GiInTex;}

#define PASS_GI_H(i) \
	pass GI_H##i \
	{ \
		VertexShader = PostProcessVS; \
		PixelShader = PS_GI_HGB; \
		RenderTarget = GiOutTex; \
	}
#define PASS_GI_V(i) \
	pass GI_V##i \
	{ \
		VertexShader = PostProcessVS; \
		PixelShader = PS_GI_VGB; \
		RenderTarget = GiInTex; \
	}

	PASS_GI_H(1)
	PASS_GI_V(1)
	PASS_GI_H(2)
	PASS_GI_V(2)
	PASS_GI_H(3)
	PASS_GI_V(3)
	PASS_GI_H(4)
	PASS_GI_V(4)
	PASS_GI_H(5)
	PASS_GI_V(5)
	PASS_GI_H(6)
	PASS_GI_V(6)
	PASS_GI_H(7)
	PASS_GI_V(7)
	PASS_GI_H(8)
	PASS_GI_V(8)
	PASS_GI_H(9)
	PASS_GI_V(9)
	PASS_GI_H(10)
	PASS_GI_V(10)
	PASS_GI_H(11)
	PASS_GI_V(11)
	PASS_GI_H(12)
	PASS_GI_V(12)

	pass GI_mix 			{VertexShader = PostProcessVS;	PixelShader = PS_GI_Mix;}

	// LIGHTING
	pass LightingColor 		{VertexShader = PostProcessVS;	PixelShader = PS_LIGHTING;}


	/////////////////////////////////////////////////////////////////////////////////////////////////////////////
	/// LENS ////////////////////////////////////////////////////////////////////////////////////////////////////
	// DOF
	pass Focus 				{ VertexShader = PostProcessVS; PixelShader = PS_Focus; 	RenderTarget = texHDR1;}
	//pass SaveFocus 			{VertexShader  = PostProcessVS; PixelShader = SaveFocus;	RenderTarget = texDOFPreviousFocus;}
	pass MatsoDOF1 			{ VertexShader = PostProcessVS; PixelShader = PS_MatsoDOF1; RenderTarget = texHDR2;}
	pass MatsoDOF2 			{ VertexShader = PostProcessVS; PixelShader = PS_MatsoDOF2; RenderTarget = texHDR1;}
	pass MatsoDOF3 			{ VertexShader = PostProcessVS; PixelShader = PS_MatsoDOF3; RenderTarget = texHDR2;}
	pass MatsoDOF4 			{ VertexShader = PostProcessVS; PixelShader = PS_MatsoDOF4;}
	
	//LENS HAZE	
	pass AL_DetectInt 		{VertexShader = PostProcessVS;PixelShader = PS_LH_DetectInt;RenderTarget = LHTexHighDetect;}
	pass AL_DetectLow 		{VertexShader = PostProcessVS;PixelShader = PS_LH_DetectLow;RenderTarget = LHTexLowDetect;}
	pass AL_DetectHigh 		{VertexShader = PostProcessVS;PixelShader = PS_LH_DetectHigh;RenderTarget = LHTexIn;}

#define PASS_AL_H(i) \
	pass AL_H##i \
	{ \
		VertexShader = PostProcessVS; \
		PixelShader = PS_LH_HGB; \
		RenderTarget = LHTexOut; \
	}
#define PASS_AL_V(i) \
	pass AL_V##i \
	{ \
		VertexShader = PostProcessVS; \
		PixelShader = PS_LH_VGB; \
		RenderTarget = LHTexIn; \
	}

	PASS_AL_H(1)
	PASS_AL_V(1)
	PASS_AL_H(2)
	PASS_AL_V(2)
	PASS_AL_H(3)
	PASS_AL_V(3)
	PASS_AL_H(4)
	PASS_AL_V(4)
	PASS_AL_H(5)
	PASS_AL_V(5)
	PASS_AL_H(6)
	PASS_AL_V(6)
	PASS_AL_H(7)
	PASS_AL_V(7)
	PASS_AL_H(8)
	PASS_AL_V(8)
	PASS_AL_H(9)
	PASS_AL_V(9)
	PASS_AL_H(10)
	PASS_AL_V(10)
	PASS_AL_H(11)
	PASS_AL_V(11)
	PASS_AL_H(12)
	PASS_AL_V(12)

	// LENS HAZE MIX
	pass AL_Magic 			{VertexShader = PostProcessVS;PixelShader = PS_LH_Mix;}

	// LENS BLOOM Sampled
	pass BloomInputDebug	{VertexShader = PostProcessVS;PixelShader = PS_DeBuGInputBloom;}
	pass BloomInput			{VertexShader = PostProcessVS;PixelShader = PS_InputBloom;RenderTarget = Blur1;}
	pass BlurH1				{ComputeShader = HorizontalFilterCS0<H_GROUP_SIZE.x, H_GROUP_SIZE.y>;DispatchSizeX = H_GROUPS.x;DispatchSizeY = H_GROUPS.y;}
	pass BlurH2				{ComputeShader = HorizontalFilterCS1<H_GROUP_SIZE.x, H_GROUP_SIZE.y>;DispatchSizeX = H_GROUPS.x;DispatchSizeY = H_GROUPS.y;}
	pass BlurV1				{ComputeShader = VerticalFilterCS0<V_GROUP_SIZE.x, V_GROUP_SIZE.y>;DispatchSizeX = V_GROUPS.x;DispatchSizeY = V_GROUPS.y;}
	pass BlurV2				{ComputeShader = VerticalFilterCS1<V_GROUP_SIZE.x, V_GROUP_SIZE.y>;DispatchSizeX = V_GROUPS.x;DispatchSizeY = V_GROUPS.y;}
	
	// RATIO
	pass Ratio				{VertexShader = PostProcessVS;PixelShader = PS_AspectRatio;}
		
	// LENS MOTION
	pass LensShake			{VertexShader = PostProcessVS;PixelShader = PS_LensShake;}
	
	// LENS
	pass LensDistortion		{VertexShader = PostProcessVS;PixelShader = PS_FISHEYE_CA;}

	// LENS BLUR
	pass BlurPrePass1 		{VertexShader = PostProcessVS;PixelShader = PS_GaussianBlur_Lens1;RenderTarget = GaussianBlur_TEX;}
	pass BlurPrePassFinal 	{VertexShader = PostProcessVS;PixelShader = PS_GaussianBlur_LensFinal;}
	pass BlurDirtPrePass1 	{VertexShader = PostProcessVS;PixelShader = PS_GaussianBlur_LensDirt1;RenderTarget = GaussianDirtBlur_TEX;}
	pass BlurDirtPrePassFinal{VertexShader = PostProcessVS;PixelShader = PS_GaussianBlur_LensDirtFinal;}
	
	// LENS SHARP
	pass LensSharpness		{VertexShader = PostProcessVS;PixelShader = PS_LumaSharpenPrePass;}
	
	
	/////////////////////////////////////////////////////////////////////////////////////////////////////////////
	/// CAMERA //////////////////////////////////////////////////////////////////////////////////////////////////
	// TONEMAPPER	
	pass GetSmall 			{VertexShader = PostProcessVS;PixelShader = GetSmallPS;RenderTarget = SmallTex;}
	pass SaveAdapt 			{VertexShader = PostProcessVS;PixelShader = SaveAdaptPS;RenderTarget = LastAdaptTex;}
	pass Main 				{VertexShader = TonemapperVST;PixelShader = PS_Tonemapper;SRGBWriteEnable = true;}
	pass AgX_processing 	{VertexShader = PostProcessVS;PixelShader = PS_AGX;}

	// COLOR BALANCE
	pass CBSample			{VertexShader = PostProcessVS;PixelShader = PS_WriteColor;RenderTarget = texColor;}
	pass CBDS				{VertexShader = PostProcessVS;PixelShader = PS_MinMax_1;RenderTarget0 = texDS_1_Min;RenderTarget1 = texDS_1_Max;RenderTarget2 = texDS_1_Mid;}
	pass CBDS2				{VertexShader = PostProcessVS;PixelShader = PS_MinMax_1x1;RenderTarget = texDS_1x1;}
	pass CBShader			{VertexShader = PostProcessVS;PixelShader = PS_RemoveTint;}
	pass CBStore			{VertexShader = PostProcessVS;PixelShader = PS_StorePrev;RenderTarget = texPrevious;}


	/////////////////////////////////////////////////////////////////////////////////////////////////////////////
	// POST PROCESSING //////////////////////////////////////////////////////////////////////////////////////////
	// LUTS
	pass LUTCOLOR			{VertexShader = PostProcessVS;PixelShader = CCLUT;}
	
	// VIGNETTE
	pass LensShadow			{VertexShader = PostProcessVS;PixelShader = PS_Vignette;}
	
	// DEBAND
	pass Deband				{VertexShader = PostProcessVS;PixelShader = PS_Deband;}

	// PIXEL SHARP & SOFTNESS
	pass PixelSharp			{VertexShader = PostProcessVS;PixelShader = PS_LumaSharpenPassDetails;}
	pass SoftBlurH			{ComputeShader = HorizontalPassCS<GROUP_WIDTH, GROUP_HEIGHT>;DispatchSizeX = DIVIDE_ROUNDING_UP(BUFFER_WIDTH, GROUP_WIDTH * SAMPLES_PER_THREAD);DispatchSizeY = DIVIDE_ROUNDING_UP(BUFFER_HEIGHT, GROUP_HEIGHT);}
	pass SoftBlurV			{ComputeShader = VerticalPassCS<GROUP_WIDTH, GROUP_HEIGHT>;DispatchSizeX = DIVIDE_ROUNDING_UP(BUFFER_HEIGHT, GROUP_WIDTH * SAMPLES_PER_THREAD);DispatchSizeY = DIVIDE_ROUNDING_UP(BUFFER_WIDTH, GROUP_HEIGHT);}
	pass Softness			{VertexShader = PostProcessVS;PixelShader = SoftnessPS;}

	/////////////////////////////////////////////////////////////////////////////////////////////////////////////
	// FINAL OUPUT with >> BLOOM MIX ////////////////////////////////////////////////////////////////////////////
	pass FINALOUTPUT		{VertexShader = PostProcessVS;PixelShader = PSBloomMixOutput;}
	pass NightStamp 		{VertexShader = PostProcessVS;PixelShader = PS_Logo;}
}

}//NS